package it.softecspa.fileproxy.services.common.comunicator.http;

public enum MimeType {

	_3DM("3dm", "x-world/x-3dmf"), _3DMF("3dmf", "x-world/x-3dmf"), _A("a", "application/octet-stream"), _AAB("aab", "application/x-authorware-bin"), _AAM("aam", "application/x-authorware-map"), _AAS("aas", "application/x-authorware-seg"), _ABC(
			"abc", "text/vndabc"), _ACGI("acgi", "text/html"), _AFL("afl", "video/animaflex"), _AI("ai", "application/postscript"), _AIF("aif", "audio/aiff")
	// ,_AIF ("aif","audio/x-aiff")
	, _AIFC("aifc", "audio/aiff")
	// ,_AIFC ("aifc","audio/x-aiff")
	, _AIFF("aiff", "audio/aiff")
	// ,_AIFF ("aiff","audio/x-aiff")
	, _AIM("aim", "application/x-aim"), _AIP("aip", "text/x-audiosoft-intra"), _ANI("ani", "application/x-navi-animation"), _AOS("aos", "application/x-nokia-9000-communicator-add-on-software"), _APS("aps", "application/mime"), _ARC("arc",
			"application/octet-stream"), _ARJ("arj", "application/arj")
	// ,_ARJ ("arj","application/octet-stream")
	, _ART("art", "image/x-jg"), _ASF("asf", "video/x-ms-asf"), _ASM("asm", "text/x-asm"), _ASP("asp", "text/asp"), _ASX("asx", "application/x-mplayer2")
	// ,_ASX ("asx","video/x-ms-asf")
	// ,_ASX ("asx","video/x-ms-asf-plugin")
	, _AU("au", "audio/basic")
	// ,_AU ("au","audio/x-au")
	// ,_AVI ("avi","application/x-troff-msvideo")
	, _AVI("avi", "video/avi")
	// ,_AVI ("avi","video/msvideo")
	// ,_AVI ("avi","video/x-msvideo")
	, _AVS("avs", "video/avs-video"), _BCPIO("bcpio", "application/x-bcpio")
	// ,_BIN ("bin","application/mac-binary")
	// ,_BIN ("bin","application/macbinary")
	// ,_BIN ("bin","application/octet-stream")
	, _BIN("bin", "application/x-binary")
	// ,_BIN ("bin","application/x-macbinary")
	, _BM("bm", "image/bmp"), _BMP("bmp", "image/bmp")
	// ,_BMP ("bmp","image/x-windows-bmp")
	, _BOO("boo", "application/book"), _BOOK("book", "application/book"), _BOZ("boz", "application/x-bzip2"), _BSH("bsh", "application/x-bsh"), _BZ("bz", "application/x-bzip"), _BZ2("bz2", "application/x-bzip2"), _C("c", "text/plain")
	// ,_C ("c","text/x-c")
	, _C__("c++", "text/plain"), _CAT("cat", "application/vndms-pkiseccat"), _CC("cc", "text/plain")
	// ,_CC ("cc","text/x-c")
	, _CCAD("ccad", "application/clariscad"), _CCO("cco", "application/x-cocoa"), _CDF("cdf", "application/cdf")
	// ,_CDF ("cdf","application/x-cdf")
	// ,_CDF ("cdf","application/x-netcdf")
	// ,_CER ("cer","application/pkix-cert")
	, _CER("cer", "application/x-x509-ca-cert"), _CHA("cha", "application/x-chat"), _CHAT("chat", "application/x-chat"), _CLASS("class", "application/java")
	// ,_CLASS ("class","application/java-byte-code")
	// ,_CLASS ("class","application/x-java-class")
	, _COM("com", "application/octet-stream")
	// ,_COM ("com","text/plain")
	, _CONF("conf", "text/plain"), _CPIO("cpio", "application/x-cpio"), _CPP("cpp", "text/x-c"), _CPT("cpt", "application/mac-compactpro")
	// ,_CPT ("cpt","application/x-compactpro")
	// ,_CPT ("cpt","application/x-cpt")
	, _CRL("crl", "application/pkcs-crl")
	// ,_CRL ("crl","application/pkix-crl")
	// ,_CRT ("crt","application/pkix-cert")
	, _CRT("crt", "application/x-x509-ca-cert")
	// ,_CRT ("crt","application/x-x509-user-cert")
	// ,_CSH ("csh","application/x-csh")
	, _CSH("csh", "text/x-scriptcsh")
	// ,_CSS ("css","application/x-pointplus")
	, _CSS("css", "text/css"), _CXX("cxx", "text/plain"), _DCR("dcr", "application/x-director"), _DEEPV("deepv", "application/x-deepv"), _DEF("def", "text/plain"), _DER("der", "application/x-x509-ca-cert"), _DIF("dif", "video/x-dv"), _DIR("dir",
			"application/x-director"), _DL("dl", "video/dl")
	// ,_DL ("dl","video/x-dl")
	, _DOC("doc", "application/msword"), _DOT("dot", "application/msword"), _DP("dp", "application/commonground"), _DRW("drw", "application/drafting"), _DUMP("dump", "application/octet-stream"), _DV("dv", "video/x-dv"), _DVI("dvi",
			"application/x-dvi"), _DWF("dwf", "drawing/x-dwf")
	// ,_DWF ("dwf","model/vnddwf")
	// ,_DWG ("dwg","application/acad")
	// ,_DWG ("dwg","image/vnddwg")
	// ,_DWG ("dwg","image/x-dwg")
	, _DXF("dxf", "application/dxf")
	// ,_DXF ("dxf","image/vnddwg")
	// ,_DXF ("dxf","image/x-dwg")
	, _DXR("dxr", "application/x-director"), _EL("el", "text/x-scriptelisp")
	// ,_ELC ("elc","application/x-bytecodeelisp")
	, _ELC("elc", "application/x-elc"), _ENV("env", "application/x-envoy"), _EPS("eps", "application/postscript"), _ES("es", "application/x-esrehber"), _ETX("etx", "text/x-setext"), _EVY("evy", "application/envoy")
	// ,_EVY ("evy","application/x-envoy")
	, _EXE("exe", "application/octet-stream"), _F("f", "text/plain")
	// ,_F ("f","text/x-fortran")
	, _F77("f77", "text/x-fortran"), _F90("f90", "text/plain")
	// ,_F90 ("f90","text/x-fortran")
	, _FDF("fdf", "application/vndfdf")
	// ,_FIF ("fif","application/fractals")
	, _FIF("fif", "image/fif"), _FLI("fli", "video/fli")
	// ,_FLI ("fli","video/x-fli")
	, _FLO("flo", "image/florian"), _FLX("flx", "text/vndfmiflexstor"), _FMF("fmf", "video/x-atomic3d-feature"), _FOR("for", "text/plain")
	// ,_FOR ("for","text/x-fortran")
	, _FPX("fpx", "image/vndfpx")
	// ,_FPX ("fpx","image/vndnet-fpx")
	, _FRL("frl", "application/freeloader"), _FUNK("funk", "audio/make"), _G("g", "text/plain"), _G3("g3", "image/g3fax"), _GIF("gif", "image/gif"), _GL("gl", "video/gl")
	// ,_GL ("gl","video/x-gl")
	, _GSD("gsd", "audio/x-gsm"), _GSM("gsm", "audio/x-gsm"), _GSP("gsp", "application/x-gsp"), _GSS("gss", "application/x-gss"), _GTAR("gtar", "application/x-gtar")
	// ,_GZ ("gz","application/x-compressed")
	, _GZ("gz", "application/x-gzip"), _GZIP("gzip", "application/x-gzip")
	// ,_GZIP ("gzip","multipart/x-gzip")
	, _H("h", "text/plain")
	// ,_H ("h","text/x-h")
	, _HDF("hdf", "application/x-hdf"), _HELP("help", "application/x-helpfile"), _HGL("hgl", "application/vndhp-hpgl"), _HH("hh", "text/plain")
	// ,_HH ("hh","text/x-h")
	// ,_HLB ("hlb","text/x-script")
	, _HLP("hlp", "application/hlp")
	// ,_HLP ("hlp","application/x-helpfile")
	// ,_HLP ("hlp","application/x-winhelp")
	, _HPG("hpg", "application/vndhp-hpgl"), _HPGL("hpgl", "application/vndhp-hpgl"), _HQX("hqx", "application/binhex")
	// ,_HQX ("hqx","application/binhex4")
	// ,_HQX ("hqx","application/mac-binhex")
	// ,_HQX ("hqx","application/mac-binhex40")
	// ,_HQX ("hqx","application/x-binhex40")
	// ,_HQX ("hqx","application/x-mac-binhex40")
	, _HTA("hta", "application/hta"), _HTC("htc", "text/x-component"), _HTM("htm", "text/html"), _HTML("html", "text/html"), _HTMLS("htmls", "text/html"), _HTT("htt", "text/webviewhtml"), _HTX("htx", "text/html"), _ICE("ice",
			"x-conference/x-cooltalk"), _ICO("ico", "image/x-icon"), _IDC("idc", "text/plain"), _IEF("ief", "image/ief"), _IEFS("iefs", "image/ief"), _IGES("iges", "application/iges")
	// ,_IGES ("iges","model/iges")
	, _IGS("igs", "application/iges")
	// ,_IGS ("igs","model/iges")
	, _IMA("ima", "application/x-ima"), _IMAP("imap", "application/x-httpd-imap"), _INF("inf", "application/inf"), _INS("ins", "application/x-internett-signup"), _IP("ip", "application/x-ip2"), _ISU("isu", "video/x-isvideo"), _IT("it", "audio/it"), _IV(
			"iv", "application/x-inventor"), _IVR("ivr", "i-world/i-vrml"), _IVY("ivy", "application/x-livescreen"), _JAM("jam", "audio/x-jam"), _JAV("jav", "text/plain")
	// ,_JAV ("jav","text/x-java-source")
	, _JAVA("java", "text/plain")
	// ,_JAVA ("java","text/x-java-source")
	, _JCM("jcm", "application/x-java-commerce"), _JFIF("jfif", "image/jpeg")
	// ,_JFIF ("jfif","image/pjpeg")
	, _JFIF_TB("jfif-tbnl", "image/jpeg"), _JPE("jpe", "image/jpeg")
	// ,_JPE ("jpe","image/pjpeg")
	, _JPEG("jpeg", "image/jpeg")
	// ,_JPEG ("jpeg","image/pjpeg")
	, _JPG("jpg", "image/jpeg")
	// ,_JPG ("jpg","image/pjpeg")
	, _JPS("jps", "image/x-jps"), _JS("js", "application/x-javascript"), _JUT("jut", "image/jutvision"), _KAR("kar", "audio/midi")
	// ,_KAR ("kar","music/x-karaoke")
	, _KSH("ksh", "application/x-ksh")
	// ,_KSH ("ksh","text/x-scriptksh")
	, _LA("la", "audio/nspaudio")
	// ,_LA ("la","audio/x-nspaudio")
	, _LAM("lam", "audio/x-liveaudio"), _LATEX("latex", "application/x-latex"), _LHA("lha", "application/lha")
	// ,_LHA ("lha","application/octet-stream")
	// ,_LHA ("lha","application/x-lha")
	, _LHX("lhx", "application/octet-stream"), _LIST("list", "text/plain"), _LMA("lma", "audio/nspaudio")
	// ,_LMA ("lma","audio/x-nspaudio")
	, _LOG("log", "text/plain")
	// ,_LSP ("lsp","application/x-lisp")
	, _LSP("lsp", "text/x-scriptlisp"), _LST("lst", "text/plain"), _LSX("lsx", "text/x-la-asf"), _LTX("ltx", "application/x-latex"), _LZH("lzh", "application/octet-stream")
	// ,_LZH ("lzh","application/x-lzh")
	// ,_LZX ("lzx","application/lzx")
	// ,_LZX ("lzx","application/octet-stream")
	// ,_LZX ("lzx","application/x-lzx")
	, _M("m", "text/plain")
	// ,_M ("m","text/x-m")
	, _M1V("m1v", "video/mpeg"), _M2A("m2a", "audio/mpeg"), _M2V("m2v", "video/mpeg"), _M3U("m3u", "audio/x-mpequrl"), _MAN("man", "application/x-troff-man"), _MAP("map", "application/x-navimap"), _MAR("mar", "text/plain"), _MBD("mbd",
			"application/mbedlet"), _MC$("mc$", "application/x-magic-cap-package-10"), _MCD("mcd", "application/mcad")
	// ,_MCD ("mcd","application/x-mathcad")
	, _MCF("mcf", "image/vasa")
	// ,_MCF ("mcf","text/mcf")
	, _MCP("mcp", "application/netmc"), _ME("me", "application/x-troff-me"), _MHT("mht", "message/rfc822"), _MHTML("mhtml", "message/rfc822")
	// ,_MID ("mid","application/x-midi")
	, _MID("mid", "audio/midi")
	// ,_MID ("mid","audio/x-mid")
	// ,_MID ("mid","audio/x-midi")
	// ,_MID ("mid","music/crescendo")
	// ,_MID ("mid","x-music/x-midi")
	// ,_MIDI ("midi","application/x-midi")
	, _MIDI("midi", "audio/midi")
	// ,_MIDI ("midi","audio/x-mid")
	// ,_MIDI ("midi","audio/x-midi")
	// ,_MIDI ("midi","music/crescendo")
	// ,_MIDI ("midi","x-music/x-midi")
	// ,_MIF ("mif","application/x-frame")
	, _MIF("mif", "application/x-mif"), _MIME("mime", "message/rfc822")
	// ,_MIME ("mime","www/mime")
	, _MJF("mjf", "audio/x-vndaudioexplosionmjuicemediafile"), _MJPG("mjpg", "video/x-motion-jpeg"), _MM("mm", "application/base64")
	// ,_MM ("mm","application/x-meme")
	, _MME("mme", "application/base64"), _MOD("mod", "audio/mod")
	// ,_MOD ("mod","audio/x-mod")
	, _MOOV("moov", "video/quicktime"), _MOV("mov", "video/quicktime"), _MOVIE("movie", "video/x-sgi-movie"), _MP2("mp2", "audio/mpeg")
	// ,_MP2 ("mp2","audio/x-mpeg")
	// ,_MP2 ("mp2","video/mpeg")
	// ,_MP2 ("mp2","video/x-mpeg")
	// ,_MP2 ("mp2","video/x-mpeq2a")
	// ,_MP3 ("mp3","audio/mpeg3")
	// ,_MP3 ("mp3","audio/x-mpeg-3")
	, _MP3("mp3", "audio/mpeg"), _MP4("mp4", "video/mpeg"), _3GP("3gp", "video/mpeg")
	// ,_MP3 ("mp3","video/x-mpeg")
	// ,_MPA ("mpa","audio/mpeg")
	, _MPA("mpa", "video/mpeg"), _MPC("mpc", "application/x-project"), _MPE("mpe", "video/mpeg"), _MPEG("mpeg", "video/mpeg")
	// ,_MPG ("mpg","audio/mpeg")
	, _MPG("mpg", "video/mpeg"), _MPGA("mpga", "audio/mpeg"), _MPP("mpp", "application/vndms-project"), _MPT("mpt", "application/x-project"), _MPV("mpv", "application/x-project"), _MPX("mpx", "application/x-project"), _MRC("mrc", "application/marc"), _MS(
			"ms", "application/x-troff-ms"), _MV("mv", "video/x-sgi-movie"), _MY("my", "audio/make"), _MZZ("mzz", "application/x-vndaudioexplosionmzz"), _NAP("nap", "image/naplps"), _NAPLPS("naplps", "image/naplps"), _NC("nc", "application/x-netcdf"), _NCM(
			"ncm", "application/vndnokiaconfiguration-message"), _NIF("nif", "image/x-niff"), _NIFF("niff", "image/x-niff"), _NIX("nix", "application/x-mix-transfer"), _NSC("nsc", "application/x-conference"), _NVD("nvd", "application/x-navidoc"), _O(
			"o", "application/octet-stream"), _ODA("oda", "application/oda"), _OMC("omc", "application/x-omc"), _OMCD("omcd", "application/x-omcdatamaker"), _OMCR("omcr", "application/x-omcregerator"), _P("p", "text/x-pascal"), _P10("p10",
			"application/pkcs10")
	// ,_P10 ("p10","application/x-pkcs10")
	, _P12("p12", "application/pkcs-12")
	// ,_P12 ("p12","application/x-pkcs12")
	, _P7A("p7a", "application/x-pkcs7-signature"), _P7C("p7c", "application/pkcs7-mime")
	// ,_P7C ("p7c","application/x-pkcs7-mime")
	, _P7M("p7m", "application/pkcs7-mime")
	// ,_P7M ("p7m","application/x-pkcs7-mime")
	, _P7R("p7r", "application/x-pkcs7-certreqresp"), _P7S("p7s", "application/pkcs7-signature"), _PART("part", "application/pro_eng"), _PAS("pas", "text/pascal"), _PBM("pbm", "image/x-portable-bitmap"), _PCL("pcl", "application/vndhp-pcl")
	// ,_PCL ("pcl","application/x-pcl")
	, _PCT("pct", "image/x-pict"), _PCX("pcx", "image/x-pcx"), _PDB("pdb", "chemical/x-pdb"), _PDF("pdf", "application/pdf"), _PFUNK("pfunk", "audio/make")
	// ,_PFUNK ("pfunk","audio/makemyfunk")
	, _PGM("pgm", "image/x-portable-graymap")
	// ,_PGM ("pgm","image/x-portable-greymap")
	, _PIC("pic", "image/pict"), _PICT("pict", "image/pict"), _PKG("pkg", "application/x-newton-compatible-pkg"), _PKO("pko", "application/vndms-pkipko"), _PL("pl", "text/plain")
	// ,_PL ("pl","text/x-scriptperl")
	, _PLX("plx", "application/x-pixclscript"), _PM("pm", "image/x-xpixmap")
	// ,_PM ("pm","text/x-scriptperl-module")
	, _PM4("pm4", "application/x-pagemaker"), _PM5("pm5", "application/x-pagemaker"), _PNG("png", "image/png"), _PNM("pnm", "application/x-portable-anymap")
	// ,_PNM ("pnm","image/x-portable-anymap")
	, _POT("pot", "application/mspowerpoint")
	// ,_POT ("pot","application/vndms-powerpoint")
	, _POV("pov", "model/x-pov"), _PPA("ppa", "application/vndms-powerpoint"), _PPM("ppm", "image/x-portable-pixmap"), _PPS("pps", "application/mspowerpoint")
	// ,_PPS ("pps","application/vndms-powerpoint")
	// ,_PPT ("ppt","application/mspowerpoint")
	, _PPT("ppt", "application/powerpoint")
	// ,_PPT ("ppt","application/vndms-powerpoint")
	// ,_PPT ("ppt","application/x-mspowerpoint")
	, _PPZ("ppz", "application/mspowerpoint"), _PRE("pre", "application/x-freelance"), _PRT("prt", "application/pro_eng"), _PS("ps", "application/postscript"), _PSD("psd", "application/octet-stream"), _PVU("pvu", "paleovu/x-pv"), _PWZ("pwz",
			"application/vndms-powerpoint"), _PY("py", "text/x-scriptphyton"), _PYC("pyc", "applicaiton/x-bytecodepython"), _QCP("qcp", "audio/vndqcelp"), _QD3("qd3", "x-world/x-3dmf"), _QD3D("qd3d", "x-world/x-3dmf"), _QIF("qif",
			"image/x-quicktime"), _QT("qt", "video/quicktime"), _QTC("qtc", "video/x-qtc"), _QTI("qti", "image/x-quicktime"), _QTIF("qtif", "image/x-quicktime"), _RA("ra", "audio/x-pn-realaudio")
	// ,_RA ("ra","audio/x-pn-realaudio-plugin")
	// ,_RA ("ra","audio/x-realaudio")
	, _RAM("ram", "audio/x-pn-realaudio"), _RAS("ras", "application/x-cmu-raster")
	// ,_RAS ("ras","image/cmu-raster")
	// ,_RAS ("ras","image/x-cmu-raster")
	, _RAST("rast", "image/cmu-raster"), _REXX("rexx", "text/x-scriptrexx"), _RF("rf", "image/vndrn-realflash"), _RGB("rgb", "image/x-rgb"), _RM("rm", "application/vndrn-realmedia")
	// ,_RM ("rm","audio/x-pn-realaudio")
	, _RMI("rmi", "audio/mid"), _RMM("rmm", "audio/x-pn-realaudio"), _RMP("rmp", "audio/x-pn-realaudio")
	// ,_RMP ("rmp","audio/x-pn-realaudio-plugin")
	, _RNG("rng", "application/ringing-tones")
	// ,_RNG ("rng","application/vndnokiaringing-tone")
	, _RNX("rnx", "application/vndrn-realplayer"), _ROFF("roff", "application/x-troff"), _RP("rp", "image/vndrn-realpix"), _RPM("rpm", "audio/x-pn-realaudio-plugin"), _RT("rt", "text/richtext")
	// ,_RT ("rt","text/vndrn-realtext")
	, _RTF("rtf", "application/rtf")
	// ,_RTF ("rtf","application/x-rtf")
	// ,_RTF ("rtf","text/richtext")
	// ,_RTX ("rtx","application/rtf")
	, _RTX("rtx", "text/richtext"), _RV("rv", "video/vndrn-realvideo"), _S("s", "text/x-asm"), _S3M("s3m", "audio/s3m"), _SAVEME("saveme", "application/octet-stream"), _SBK("sbk", "application/x-tbook"), _SCM("scm", "application/x-lotusscreencam")
	// ,_SCM ("scm","text/x-scriptguile")
	// ,_SCM ("scm","text/x-scriptscheme")
	// ,_SCM ("scm","video/x-scm")
	, _SDML("sdml", "text/plain"), _SDP("sdp", "application/sdp")
	// ,_SDP ("sdp","application/x-sdp")
	, _SDR("sdr", "application/sounder"), _SEA("sea", "application/sea")
	// ,_SEA ("sea","application/x-sea")
	, _SET("set", "application/set"), _SGM("sgm", "text/sgml")
	// ,_SGM ("sgm","text/x-sgml")
	, _SGML("sgml", "text/sgml")
	// ,_SGML ("sgml","text/x-sgml")
	, _SH("sh", "application/x-bsh")
	// ,_SH ("sh","application/x-sh")
	// ,_SH ("sh","application/x-shar")
	// ,_SH ("sh","text/x-scriptsh")
	, _SHAR("shar", "application/x-bsh")
	// ,_SHAR ("shar","application/x-shar")
	, _SHTML("shtml", "text/html")
	// ,_SHTML ("shtml","text/x-server-parsed-html")
	, _SID("sid", "audio/x-psid"), _SIT("sit", "application/x-sit")
	// ,_SIT ("sit","application/x-stuffit")
	, _SKD("skd", "application/x-koan"), _SKM("skm", "application/x-koan"), _SKP("skp", "application/x-koan"), _SKT("skt", "application/x-koan"), _SL("sl", "application/x-seelogo"), _SMI("smi", "application/smil"), _SMIL("smil", "application/smil"), _SND(
			"snd", "audio/basic")
	// ,_SND ("snd","audio/x-adpcm")
	, _SOL("sol", "application/solids"), _SPC("spc", "application/x-pkcs7-certificates")
	// ,_SPC ("spc","text/x-speech")
	, _SPL("spl", "application/futuresplash"), _SPR("spr", "application/x-sprite"), _SPRITE("sprite", "application/x-sprite"), _SRC("src", "application/x-wais-source"), _SSI("ssi", "text/x-server-parsed-html"), _SSM("ssm",
			"application/streamingmedia"), _SST("sst", "application/vndms-pkicertstore"), _STEP("step", "application/step"), _STL("stl", "application/sla")
	// ,_STL ("stl","application/vndms-pkistl")
	// ,_STL ("stl","application/x-navistyle")
	, _STP("stp", "application/step"), _SV4CPIO("sv4cpio", "application/x-sv4cpio"), _SV4CRC("sv4crc", "application/x-sv4crc"), _SVF("svf", "image/vnddwg")
	// ,_SVF ("svf","image/x-dwg")
	, _SVR("svr", "application/x-world")
	// ,_SVR ("svr","x-world/x-svr")
	, _SWF("swf", "application/x-shockwave-flash"), _T("t", "application/x-troff"), _TALK("talk", "text/x-speech"), _TAR("tar", "application/x-tar"), _TBK("tbk", "application/toolbook")
	// ,_TBK ("tbk","application/x-tbook")
	, _TCL("tcl", "application/x-tcl")
	// ,_TCL ("tcl","text/x-scripttcl")
	, _TCSH("tcsh", "text/x-scripttcsh"), _TEX("tex", "application/x-tex"), _TEXI("texi", "application/x-texinfo"), _TEXINFO("texinfo", "application/x-texinfo")
	// ,_TEXT ("text","application/plain")
	, _TEXT("text", "text/plain"), _TGZ("tgz", "application/gnutar")
	// ,_TGZ ("tgz","application/x-compressed")
	, _TIF("tif", "image/tiff")
	// ,_TIF ("tif","image/x-tiff")
	, _TIFF("tiff", "image/tiff")
	// ,_TIFF ("tiff","image/x-tiff")
	, _TR("tr", "application/x-troff"), _TSI("tsi", "audio/tsp-audio"), _TSP("tsp", "application/dsptype")
	// ,_TSP ("tsp","audio/tsplayer")
	, _TSV("tsv", "text/tab-separated-values"), _TURBOT("turbot", "image/florian"), _TXT("txt", "text/plain"), _UIL("uil", "text/x-uil"), _UNI("uni", "text/uri-list"), _UNIS("unis", "text/uri-list"), _UNV("unv", "application/i-deas"), _URI("uri",
			"text/uri-list"), _URIS("uris", "text/uri-list"), _USTAR("ustar", "application/x-ustar")
	// ,_USTAR ("ustar","multipart/x-ustar")
	, _UU("uu", "application/octet-stream")
	// ,_UU ("uu","text/x-uuencode")
	, _UUE("uue", "text/x-uuencode"), _VCD("vcd", "application/x-cdlink"), _VCS("vcs", "text/x-vcalendar"), _VDA("vda", "application/vda"), _VDO("vdo", "video/vdo"), _VEW("vew", "application/groupwise"), _VIV("viv", "video/vivo")
	// ,_VIV ("viv","video/vndvivo")
	, _VIVO("vivo", "video/vivo")
	// ,_VIVO ("vivo","video/vndvivo")
	, _VMD("vmd", "application/vocaltec-media-desc"), _VMF("vmf", "application/vocaltec-media-file"), _VOC("voc", "audio/voc")
	// ,_VOC ("voc","audio/x-voc")
	, _VOS("vos", "video/vosaic"), _VOX("vox", "audio/voxware"), _VQE("vqe", "audio/x-twinvq-plugin"), _VQF("vqf", "audio/x-twinvq"), _VQL("vql", "audio/x-twinvq-plugin"), _VRML("vrml", "application/x-vrml")
	// ,_VRML ("vrml","model/vrml")
	// ,_VRML ("vrml","x-world/x-vrml")
	, _VRT("vrt", "x-world/x-vrt"), _VSD("vsd", "application/x-visio"), _VST("vst", "application/x-visio"), _VSW("vsw", "application/x-visio"), _W60("w60", "application/wordperfect60"), _W61("w61", "application/wordperfect61"), _W6W("w6w",
			"application/msword"), _WAV("wav", "audio/wav")
	// ,_WAV ("wav","audio/x-wav")
	, _WB1("wb1", "application/x-qpro"), _WBMP("wbmp", "image/vndwapwbmp"), _WEB("web", "application/vndxara"), _WIZ("wiz", "application/msword"), _WK1("wk1", "application/x-123"), _WMF("wmf", "windows/metafile"), _WML("wml", "text/vndwapwml"), _WMLC(
			"wmlc", "application/vndwapwmlc"), _WMLS("wmls", "text/vndwapwmlscript"), _WMLSC("wmlsc", "application/vndwapwmlscriptc"), _WORD("word", "application/msword"), _WP("wp", "application/wordperfect"), _WP5("wp5", "application/wordperfect")
	// ,_WP5 ("wp5","application/wordperfect60")
	, _WP6("wp6", "application/wordperfect"), _WPD("wpd", "application/wordperfect")
	// ,_WPD ("wpd","application/x-wpwin")
	, _WQ1("wq1", "application/x-lotus"), _WRI("wri", "application/mswrite")
	// ,_WRI ("wri","application/x-wri")
	, _WRL("wrl", "application/x-world")
	// ,_WRL ("wrl","model/vrml")
	// ,_WRL ("wrl","x-world/x-vrml")
	// ,_WRZ ("wrz","model/vrml")
	, _WRZ("wrz", "x-world/x-vrml"), _WSC("wsc", "text/scriplet"), _WSRC("wsrc", "application/x-wais-source"), _WTK("wtk", "application/x-wintalk"), _XBM("xbm", "image/x-xbitmap")
	// ,_XBM ("xbm","image/x-xbm")
	// ,_XBM ("xbm","image/xbm")
	, _XDR("xdr", "video/x-amt-demorun"), _XGZ("xgz", "xgl/drawing"), _XIF("xif", "image/vndxiff"), _XL("xl", "application/excel"), _XLA("xla", "application/excel")
	// ,_XLA ("xla","application/x-excel")
	// ,_XLA ("xla","application/x-msexcel")
	, _XLB("xlb", "application/excel")
	// ,_XLB ("xlb","application/vndms-excel")
	// ,_XLB ("xlb","application/x-excel")
	, _XLC("xlc", "application/excel")
	// ,_XLC ("xlc","application/vndms-excel")
	// ,_XLC ("xlc","application/x-excel")
	, _XLD("xld", "application/excel")
	// ,_XLD ("xld","application/x-excel")
	, _XLK("xlk", "application/excel")
	// ,_XLK ("xlk","application/x-excel")
	, _XLL("xll", "application/excel")
	// ,_XLL ("xll","application/vndms-excel")
	// ,_XLL ("xll","application/x-excel")
	, _XLM("xlm", "application/excel")
	// ,_XLM ("xlm","application/vndms-excel")
	// ,_XLM ("xlm","application/x-excel")
	, _XLS("xls", "application/excel")
	// ,_XLS ("xls","application/vndms-excel")
	// ,_XLS ("xls","application/x-excel")
	// ,_XLS ("xls","application/x-msexcel")
	, _XLT("xlt", "application/excel")
	// ,_XLT ("xlt","application/x-excel")
	, _XLV("xlv", "application/excel")
	// ,_XLV ("xlv","application/x-excel")
	, _XLW("xlw", "application/excel")
	// ,_XLW ("xlw","application/vndms-excel")
	// ,_XLW ("xlw","application/x-excel")
	// ,_XLW ("xlw","application/x-msexcel")
	, _XM("xm", "audio/xm"), _XML("xml", "application/xml")
	// ,_XML ("xml","text/xml")
	, _XMZ("xmz", "xgl/movie"), _XPIX("xpix", "application/x-vndls-xpix")
	// ,_XPM ("xpm","image/x-xpixmap")
	, _XPM("xpm", "image/xpm"), _X_PNG("x-png", "image/png"), _XSR("xsr", "video/x-amt-showrun"), _XWD("xwd", "image/x-xwd")
	// ,_XWD ("xwd","image/x-xwindowdump")
	, _XYZ("xyz", "chemical/x-pdb"), _Z("z", "application/x-compress")
	// ,_Z ("z","application/x-compressed")
	// ,_ZIP ("zip","application/x-compressed")
	// ,_ZIP ("zip","application/x-zip-compressed")
	, _ZIP("zip", "application/zip")
	// ,_ZIP ("zip","multipart/x-zip")
	, _ZOO("zoo", "application/octet-stream"), _ZSH("zsh", "text/x-scriptzsh");

	private String ext;
	private String mimetype;

	private MimeType(String ext, String mimetype) {
		this.ext = ext;
		this.mimetype = mimetype;
	}

	public String toString() {
		return mimetype;
	}

	public String getExt() {
		return ext;
	}

	public String getMimetype() {
		return mimetype;
	}

}
