package it.softecspa.fileproxy.services.common.core;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.log4j.Logger;

public abstract class DelayedExecution implements Runnable {

	protected Logger log = Logger.getLogger(getClass());
	protected int millisenconds;
	private ScheduledExecutorService executor;
	
	
	public boolean executeNow() {
		this.millisenconds = 0;
		if (log.isDebugEnabled()) log.debug("Launch deferred action soon as possible: "+getClass().getSimpleName());
		
		try {
			/* 
			 * Evoluzione 2012-07-04 
			 * Lancio il complete in modo asincrono
			 * Questo mi assicura la chiusura della connessione dello stream della chiamata HTTP
			 */
			Thread thread = new Thread(this, getClass().getSimpleName());
			thread.start();
			return true;
		} catch (Exception e) {
			log.fatal("Error scheduling "+getClass().getSimpleName()+" thread; run now!",e);
			// In caso di errore, eseguo il metodo direttamente enon come THREAD
			this.run();
			return false;
		}		
	}
	
	/**
	 * @param millisenconds
	 * @return
	 */
	public boolean executeWithDelay(int millisenconds) {
		if (millisenconds<=0) return executeNow();
		
		this.millisenconds = millisenconds;
		if (log.isDebugEnabled()) log.debug("Launch deferred action (delay "+millisenconds+" millis): "+getClass().getSimpleName());
		try {
			/*
			 * Evoluzione 2014-05-02 
			 * Lancio il complete in modo asincrono
			 * Questo mi assicura la chiusura della connessione dello stream della chiamata HTTP
			 * Faccio partire il thread con un ritardo
			 * http://stackoverflow.com/questions/19999231/how-to-start-a-thread-after-specified-time-delay-in-java
			 * http://stackoverflow.com/questions/3072173/how-to-call-a-method-after-a-delay
			 */
			executor = Executors.newSingleThreadScheduledExecutor();
			executor.schedule(this, millisenconds, TimeUnit.MILLISECONDS);
			return true;
		} catch (Exception e) {
			log.fatal("Error scheduling "+getClass()+" thread; run now!",e);
			// In caso di errore, eseguo il metodo direttamente enon come THREAD
			this.run();
			return false;
		}
	}
	
	public abstract void core();
	
	@Override
	public void run() {
		if (log.isDebugEnabled()) log.debug("Deferred action start after "+millisenconds+" millis: "+getClass().getSimpleName());
		
		try {
			core();
		} catch (Exception e) {
			log.error("Unhandled exception in "+getClass(),e);
		} catch (Error e) {
			log.error("Unhandled error in "+getClass(),e);
		} finally {
			/*
			 * E' importante fare lo shutdown altrimenti rimane appeso il thread 
			 */
			if (executor!=null) {
				executor.shutdown();
			}			
		}
	}
		
	
}
