package it.softecspa.fileproxy.services.common.core;

import it.softecspa.fileproxy.services.common.comunicator.http.HttpRemote;
import it.softecspa.fileproxy.services.common.core.response.Entry;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MyHttpServletResponse {

	private HttpServletRequest request;
	private HttpServletResponse response;
	private HttpRemote httpRemote;

	private Entry[] info;
	private String statement_key;
	private String statement;
	
	private Object input;
	private Object output;
	
	private EnterpriseCalendar start;
	

	public MyHttpServletResponse(HttpServletRequest request, HttpServletResponse response) {
		this.request = request;
		this.response = response;
		this.httpRemote = new HttpRemote(request);
		//
		this.start = EnterpriseCalendar.now();
	}

	public HttpServletRequest getHttpServletRequest() {
		return request;
	}

	public HttpServletResponse getHttpServletResponse() {
		return response;
	}

	public HttpRemote getHttpRemote() {
		return httpRemote;
	}

	
	
	public Object getInput() {
		return input;
	}

	public void setInput(Object input) {
		this.input = input;
	}

	
	public Object getOutput() {
		return output;
	}

	public void setOutput(Object output) {
		this.output = output;
	}

	public String getStatement() {
		return statement;
	}

	public void setStatement(String statement) {
		this.statement = statement;
	}

	String getStatementKey() {
		return statement_key;
	}

	void setStatementKey(String statement_key) {
		this.statement_key = statement_key;
	}

	EnterpriseCalendar getStart() {
		return start;
	}

	Entry[] getInfo() {
		return info;
	}

	public void setInfo(Entry[] info) {
		this.info = info;
	}

}