package it.softecspa.fileproxy.services.common.core;

import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.fileproxy.services.common.ResponseResult;

import javax.servlet.http.HttpServletResponse;


public class MyReturn {

	private String code;
	private String message;
	private ResponseResult result;
	
	private boolean trace;
	private boolean positive;
	
	// Stato della risposta HTTP
	private int httpStatus;
	
	/**
	 * Risposta recuperata da ResponseOutcome 
	 * @param outcome
	 */
	public MyReturn(ResponseOutcome outcome, ResponseResult result) {
		this(outcome.getReturnCode(), outcome.getMessage(), result, outcome.isOk(), outcome.isTraceLog());
	}
	
	
	/**
	 * Risposta con esito postivo o negativo
	 * Taccio sicuramente le ripsote con esito negativo
	 * @param outcome
	 */
	public MyReturn(String code, String message, ResponseResult result, boolean positive, boolean trace) {
		this.code = code;
		this.message = message;
		this.result = result;
		this.positive = positive;
		this.trace = trace;
		this.httpStatus = HttpServletResponse.SC_OK;
	}
	
	

	public boolean isPositive() {
		return positive;
	}

	public boolean isNegative() {
		return !positive;
	}

	void setPositive(boolean positive) {
		this.positive = positive;
	}
	
	
	public String toString() {
		return "["+code+"] - '"+message+"'";
	}

	
	public boolean isTrace() {
		return trace;
	}

	void setTrace(boolean trace) {
		this.trace = trace;
	}

	public String getCode() {
		return code;
	}

	void setCode(String code) {
		this.code = code;
	}

	
	public String getMessage() {
		return message;
	}

	void setMessage(String message) {
		this.message = message;
	}

	
	public ResponseResult getResult() {
		return result;
	}

	void setResult(ResponseResult result) {
		this.result = result;
	}


	public int getHttpStatus() {
		return httpStatus;
	}

	public void changeHttpStatus(int httpStatus) {
		this.httpStatus = httpStatus;
	}

	


	
	

	
}