package it.softecspa.fileproxy.services.common.core.request;

import java.io.InputStream;
import java.io.Serializable;

public interface InputStreamReaderJSON <J extends Serializable> extends MethodPostMandatory {

	/**
	 * Restituisce l'input stream della request
	 * @return
	 */
	public InputStream takeInputStream();

	/**
	 * Associa l'input stream della request per utilizzi nel corso dell'elaborazione
	 * @param inputStream
	 */
	public void putInputStream(InputStream inputStream);
	
	
	/**
	 * Restituisce il documento JSON letto ed eventualemnte bufferizzato
	 * @return
	 */
	public JsonMapper<J> takeJsonDocument();

	/**
	 * Memorizza il documento JSON per utilizzi vari nel corso dell'elaborazione
	 * @param inputDocument
	 */
	public void bufferizeInputDocument(JsonMapper<J> mapper);
	
	
}
