package it.softecspa.fileproxy.services.common.core.request;

import it.softecspa.kahuna.util.xml.XmlRoot;

import java.io.InputStream;

public interface InputStreamReaderXML<X extends XmlRoot> extends MethodPostMandatory {

	/**
	 * Restituisce l'input stream della request
	 * @return
	 */
	public InputStream takeInputStream();

	/**
	 * Associa l'input stream della request per utilizzi nel corso dell'elaborazione
	 * @param inputStream
	 */
	public void putInputStream(InputStream inputStream);
	
	
	/**
	 * Restituisce il documento XML letto ed eventualmente bufferizzato
	 * @return
	 */
	public X takeBufferedInputDocument();

	/**
	 * Memorizza il documento XML per utilizzi vari nel corso dell'elaborazione
	 * @param inputDocument
	 */
	public void bufferizeInputDocument(X inputDocument);
	
	
}
