package it.softecspa.fileproxy.services.common.core.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

import org.apache.log4j.Logger;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;


public class JsonMapper<J extends Serializable> {

	private Logger log = Logger.getLogger(getClass());
	private ObjectMapper mapper;
	private J object;
	
	public JsonMapper() {
		mapper = new ObjectMapper();
	}

	public ObjectMapper getMapper() {
		return mapper;
	}
	
	public J readValue(InputStream inputStream, Class<J>clazz) throws JsonParseException, JsonMappingException, IOException {
		object = mapper.readValue(inputStream, clazz);
		return object;
	}

	public String print() {
		if (object==null) return ""; 
		try {
			// http://fasterxml.github.io/jackson-databind/javadoc/2.3.0/com/fasterxml/jackson/databind/SerializationFeature.html
			mapper.enable(SerializationFeature.INDENT_OUTPUT);
			return mapper.writeValueAsString(object);
		} catch (JsonGenerationException e) {
			log.error("Error formatting input JSON",e);
		} catch (JsonMappingException e) {
			log.error("Error formatting input JSON",e);
		} catch (IOException e) {
			log.error("Error formatting input JSON",e);
		}
		return null;
	}

	public J getJsonObject() {
		return object;
	}
	
}
