package it.softecspa.fileproxy.services.common.core.request;

import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;

public enum Protocollo {

   /* _0 (0,"Sun")
   ,*/_1 (1,"Mercury","2.0.0")
	, _2 (2,"Venus","2.6.0")
	, _3 (3,"Earth","2.7.1")
	, _4 (4,"Mars","2.8.0")
	, _5 (5,"Jupiter","2.10.8")
	;
	  
	    
	  
	private int value;
	private String nickname;
	private String version;
	
	
	private Protocollo(int value, String nickname, String version) {
		this.value = value;
		this.nickname = nickname;
		this.version = version;
	}

	public static Protocollo parse(String value) {
		return Protocollo.valueOf("_"+value);
	}
	
	public static Protocollo parse(int value) {
		return Protocollo.valueOf("_"+value);
	}
	
	
	public void check(Protocollo min, Protocollo max) throws CheckerException {
		if ((min!=null && this.value<min.value()) || 
			(max!=null && this.value>max.value())) {
			if (min==null && max!=null) throw new CheckerException(ResponseOutcome.PROTOCOL_VERSION_OUT_OF_RANGE, "<="+max);
			if (min!=null && max==null) throw new CheckerException(ResponseOutcome.PROTOCOL_VERSION_OUT_OF_RANGE, ">="+min);
			throw new CheckerException(ResponseOutcome.PROTOCOL_VERSION_OUT_OF_RANGE, min+":"+max);
		} 
	}
	
	/**
	 * Protocollo < del valore di riferimento
	 * @param compare
	 * @return
	 */
	public boolean under(Protocollo compare) {
		if (compare==null) return false;
		return this.value<compare.value;
	}
	
	/**
	 * Protocollo <= del valore di riferimento
	 * @param compare
	 * @return
	 */
	public boolean underOrEqual(Protocollo compare) {
		if (compare==null) return false;
		return this.value<=compare.value;
	}
	
	/**
	 * Protocollo == al valore di riferimento
	 * @param compare
	 * @return
	 */
	public boolean is(Protocollo compare) {
		return equals(compare);
	}
	
	/**
	 * Protocollo == al valore di riferimento
	 * @param compare
	 * @return
	 */
	public boolean equals(Protocollo compare) {
		if (compare==null) return false;
		return this.value==compare.value;
	}
	
	/**
	 * Protocollo >= del valore di riferimento
	 * @param compare
	 * @return
	 */
	public boolean equalOrOver(Protocollo compare) {
		return this.value>=compare.value;
	}
	
	/**
	 * Protocollo > del valore di riferimento
	 * @param compare
	 * @return
	 */
	public boolean over(Protocollo compare) {
		if (compare==null) return false;
		return this.value>compare.value;
	}

	/**
	 * Restituisce il valore numerico del protocollo
	 * @return
	 */
	public int value() {
		return value;
	}

	/**
	 * Restituisce il soprannome del protocollo
	 * @return
	 */
	public String getNikname() {
		return nickname;
	}
    
	@Override
	public String toString() {
		return ""+this.value;
	}

	public String getVersionFrom() {
		return version;
	}

	
	
}
