package it.softecspa.fileproxy.services.common.core.request;


/**
 * Interfaccia universale che tutte le classi request devono estendere nel caso siano autenticate
 * - username
 * - password
 */
public interface UniversalAuthenticatedRequest {
	
	/**
	 * Username utente 
	 * @return
	 */
	public String getUsername();

	public void setUsername(String value);
	
	
	/**
	 * Password dell'utente
	 * Pu essere impostata sia in chiaro che in formato MD5
	 * Se in chiaro  subito trasformata nel suo MD5
	 * @return
	 */
	public String getPassword();
	
	public void setPassword(String value);
	
	
	/**
	 * Token di authenticazione rilasciato dal' ID Provider
	 * @return
	 */
	public String getAccessToken();

	public void setAccessToken(String value);

	
	/**
	 * Organizzaone legata al TOKEN da verificare 
	 * @return
	 */
	public String getOrganization();
	
	public void setOrganization(String value);
	
}
