package it.softecspa.fileproxy.services.common.core.response;

import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.fileproxy.services.common.core.MyReturn;
import it.softecspa.fileproxy.services.common.core.response.body.BodyXML;
import it.softecspa.fileproxy.services.common.core.response.body.MyBody;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.portal.Version;

import java.io.UnsupportedEncodingException;

import org.apache.log4j.Logger;

public class AbstractDummyResponse implements UniversalResponse {

	private Logger log = Logger.getLogger(getClass());

	private MyReturn myreturn; 
	private MyBody body;
	
	
	public AbstractDummyResponse(ResponseOutcome outcome) {
		this.myreturn = new MyReturn(outcome, null);
		
		Version versione = Version.getInstance();
		String message = "<APPBIKE version=\"" + versione.toString() + "\">" + 
							"<RETURN>" + 
								"<CODE>" + outcome.getId() + "</CODE>" + 
								"<MESSAGE>" + outcome.getMessage() + "</MESSAGE>" + 
							"</RETURN>" + 
						 "</APPBIKE>";
		try {
			addBody(new BodyXML(generateXML(message, "UTF-8", null, false)));
		} catch (UnsupportedEncodingException e) {
			log.fatal("Unhandled exception", e);
			addBody(new BodyXML(message.getBytes()));
		}
	}

	private byte[] generateXML(String message, String charsetName, String dtd, boolean pretty) throws UnsupportedEncodingException {
		if (log.isDebugEnabled()) log.debug("Translate XmlElement in XML layout");

		String xml = "<?xml version=\"1.0\" encoding=\"" + charsetName + "\"?>";
		if (dtd != null) {
			xml += "<!DOCTYPE properties SYSTEM \"" + dtd + "\">";
		}
		xml += message;

		if (pretty) {
			try {
				xml = XString.prettyXML(xml);
			} catch (Exception e) {
				log.warn("Problem \"pretty\" XML response", e);
			}
		}

		try {
			return xml.getBytes(charsetName);
		} catch (UnsupportedEncodingException e) {
			throw e;
		}
	}

	
	@Override
	public String getReturnCode() {
		return myreturn.getCode();
	}
	
	
	@Override
	public String getReturnMessage() {
		return myreturn.getMessage();
	}
	
	
	
	@Override
	public MyBody takeBody() {
		return this.body;
	}

	@Override
	public void addBody(MyBody body) {
		this.body = body;
	}

	

	@Override
	public void setReturn(MyReturn myreturn) {
		this.myreturn = myreturn;
	}

	@Override
	public MyReturn takeMyReturn() {
		return myreturn;
	}

	

}