package it.softecspa.fileproxy.services.common.core.response;

import it.softecspa.fileproxy.services.common.core.MyReturn;
import it.softecspa.fileproxy.services.common.core.response.body.MyBody;

/**
 * Interfaccia universale che tutte le classi response devono estendere
 * - return code
 * - return message
 * - result (opzionale)
 * + body
 */
public interface UniversalResponse {

	
	public String getReturnCode();

	public String getReturnMessage();
	
	public void setReturn(MyReturn myreturn);
	
	public MyReturn takeMyReturn();
	
	
	/**
	 * Da utilizzare per impostare un body
	 * @param body
	 */
	public MyBody takeBody();
	
	public void addBody(MyBody body);	

	
	
	
	
}
