package it.softecspa.fileproxy.services.common.core.response.body;

import it.softecspa.fileproxy.services.common.core.BodyResponseException;

import java.io.IOException;
import java.util.zip.GZIPOutputStream;

import javax.servlet.ServletOutputStream;

public class BodyBase64 extends MyBody {

	private String body;
	private String name;
	
	public BodyBase64(String body) {
		super(true);
		this.body = body;
	}
	
	public BodyBase64(String body, String name) {
		super();
		this.body = body;
		this.name = name;
	}
	
	
		
	@Override
	protected void write() throws IOException, BodyResponseException {
		if (body==null) return;
		if (log.isDebugEnabled()) log.debug("Sending base64 encoded stream in response output");
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/octet-stream");
		if (name!=null) {
			response.setHeader("Content-Disposition", "attachment; filename=" + name);
		}
		response.setHeader("Content-Transfer-Encoding","base64");
		
		ServletOutputStream out = response.getOutputStream();	
		if (gzip) {
			response.setHeader("Content-Encoding","gzip");
			//
			byte[] abyte = body.getBytes("UTF-8");
			GZIPOutputStream zipout = new GZIPOutputStream(out);
			zipout.write(abyte);
			zipout.flush();
			zipout.close();												
		} else {
			byte[] abyte = body.getBytes("UTF-8");	
			response.setContentLength(abyte.length);
			out.write(abyte);					
			out.flush();
		}
		
	}

}
