package it.softecspa.fileproxy.services.common.core.response.body;

import it.softecspa.fileproxy.services.common.core.BodyResponseException;
import it.softecspa.kahuna.io.File;

import java.io.IOException;

public class BodyFileAttach extends MyBody {

	protected File file;
	protected int chunksize;
	
	protected boolean inline;
	
	
	public BodyFileAttach(File file, int chunksize) {
		super(true);
		this.file = file;
		this.chunksize = chunksize;
	}
	
	public BodyFileAttach(File file, boolean inline, int chunksize) {
		super(true);
		this.file = file;
		this.chunksize = chunksize;
		this.inline = inline;
	}
	
	
		
	@Override
	protected void write() throws IOException, BodyResponseException {
		if (file==null) return;
		if (log.isDebugEnabled()) log.debug("Sending attachment file in response output stream in chunked mode");
		
		// set response headers (it is always better to write header's before writing to response stream)
	   
		if (inline) {
			// if Content-Disposition header value is set to inline, the response is displayed in browser
			response.setHeader("Content-Disposition", "inline; filename=" + file.getName());
		} else {
			 response.setContentType("application/octet-stream");
			// if Content-Disposition header value is set to attachment, file can be downloaded as attachment
			response.setHeader("Content-Disposition", "attachment; filename=" + file.getName());
		}
		response.setContentLength(new Long(file.length()).intValue());
		
		//
		writeFileGeneric(file, chunksize);		
	}

}
