package it.softecspa.fileproxy.services.common.core.response.body;

import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.fileproxy.services.common.core.BodyResponseException;
import it.softecspa.fileproxy.services.common.core.response.JsonResponse;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;

import javax.servlet.ServletOutputStream;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;


public class BodyJson <J extends Serializable> extends MyBody  {

	//private String json;
	private J object;
	private boolean indent;
	
	/*
	public BodyJson(String json) {
		super(true);
		this.json = json;
	}
	*/
	
	public BodyJson(J object) throws ManagerException {
		this(object,true);
	}
	
	public BodyJson(J object, boolean indent) throws ManagerException {
		super(true);
		this.object = object;
		this.indent = indent;
	}
	
	
		
	@Override
	protected void write() throws IOException, BodyResponseException {
		if (object instanceof JsonResponse) {
			((JsonResponse)object).setStatus(myReturn.getCode());
			((JsonResponse)object).setMessage(myReturn.getMessage());
			if (myReturn.getResult()!=null) {
				((JsonResponse)object).setResult(myReturn.getResult().toString());
			}
		}
		
		
		String json = null;
		try {
			json = object2string(object, indent);
		} catch (ManagerException e) {
			new BodyResponseException(e);
		}
		
		if (json==null) return;
		if (log.isDebugEnabled()) log.debug("Sending "+(gzip?"compressed ":"")+"text message in response output stream");
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		ServletOutputStream out = response.getOutputStream();	
		if (gzip) {
			response.setHeader("Content-Encoding","gzip");
			//
			byte[] abyte = json.getBytes("UTF-8");
			GZIPOutputStream zipout = new GZIPOutputStream(out);
			zipout.write(abyte);
			zipout.flush();
			zipout.close();												
		} else {
			byte[] abyte = json.getBytes("UTF-8");		
			response.setContentLength(abyte.length);
			out.write(abyte);					
			out.flush();
		}
		
	}
	
	
	public static String object2string(Object object, boolean indent) throws ManagerException {
		try {
			ObjectMapper mapper = new ObjectMapper();
			Writer strWriter = new StringWriter();
			//
			if (indent) mapper.enable(SerializationFeature.INDENT_OUTPUT);
			mapper.writeValue(strWriter, object);
			//
			return strWriter.toString();
		
		} catch (JsonGenerationException e) {
			throw new ManagerException(new CheckerException(ResponseOutcome.MALFORMD_JSON_DOCUMENT,"JsonGenerationException: "+object.getClass().getName()));
		} catch (JsonMappingException e) {
			throw new ManagerException(new CheckerException(ResponseOutcome.MALFORMD_JSON_DOCUMENT,"JsonMappingException: "+object.getClass().getName())); 
		} catch (IOException e) {
			throw new ManagerException("IOException in json serialization object, class "+object.getClass().getName(),e);
		} catch (Exception e) {
			throw new ManagerException("Unhadled exception in json serialization object, class "+object.getClass().getName(),e);
		}
	}

	public J getJsonObject() {
		return object;
	}

}
