package it.softecspa.fileproxy.services.common.core.response.body;

import it.softecspa.fileproxy.services.common.core.BodyResponseException;

import java.io.IOException;
import java.util.zip.GZIPOutputStream;

import javax.servlet.ServletOutputStream;

public class BodyText extends MyBody {

	private String text;
	
	
	public BodyText(String text) {
		super(true);
		this.text = text;
	}
	
	
		
	@Override
	protected void write() throws IOException, BodyResponseException {
		if (text==null) return;
		if (log.isDebugEnabled()) log.debug("Sending "+(gzip?"compressed ":"")+"text message in response output stream");
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/plain");
		
		ServletOutputStream out = response.getOutputStream();	
		if (gzip) {
			response.setHeader("Content-Encoding","gzip");
			//
			byte[] abyte = text.getBytes("UTF-8");
			GZIPOutputStream zipout = new GZIPOutputStream(out);
			zipout.write(abyte);
			zipout.flush();
			zipout.close();												
		} else {
			byte[] abyte = text.getBytes("UTF-8");	
			response.setContentLength(abyte.length);
			out.write(abyte);					
			out.flush();
		}
		
	}

}
