package it.softecspa.fileproxy.services.common.core.response.body;

import it.softecspa.fileproxy.services.common.core.BodyResponseException;
import it.softecspa.kahuna.util.xml.XmlRoot;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPOutputStream;

import javax.servlet.ServletOutputStream;

public class BodyXML extends MyBody {

	private byte[] xml;
	
	
	public BodyXML(byte[] xml) {
		super(true);
		this.xml = xml;
	}
	
	public BodyXML(String xml) throws UnsupportedEncodingException {
		super(true);
		if (xml!=null) {
			this.xml = xml.getBytes("UTF-8");
		}
	}
	
	public BodyXML(XmlRoot root) throws UnsupportedEncodingException {
		super(true);
		if (root!=null) {
			this.xml = root.generateXML("UTF-8");
		}
	}
	
		
	@Override
	public void write() throws IOException, BodyResponseException {
		if (xml==null) return;
		if (log.isDebugEnabled()) log.debug("Send XML as "+(gzip?"compressed ":"")+"byte array throw output stream");
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/xml");
		response.setContentLength(xml.length);
		
		ServletOutputStream out = response.getOutputStream();
		if (gzip) {
			response.setHeader("Content-Encoding","gzip");
			//
			GZIPOutputStream zipout = new GZIPOutputStream(out);
			zipout.write(xml);
			zipout.flush();
			zipout.close();							
		} else {			
			out.write(xml);
			out.flush();		
		}
		
	}

}
