package it.softecspa.fileproxy.services.common.core.response.body;

import it.softecspa.fileproxy.services.common.ManagerException;
import it.softecspa.fileproxy.services.common.core.BodyResponseException;
import it.softecspa.fileproxy.services.common.core.response.JsonResponseKO;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

public class ErrorBodyJson extends ErrorBody {

	@Override
	protected void write() throws IOException, BodyResponseException {
		
		String json;
		try {
			json = BodyJson.object2string(new JsonResponseKO(myReturn.getCode(),myReturn.getMessage()),true);
		} catch (ManagerException e) {
			throw new BodyResponseException(e);
		}
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("application/json");
		
		ServletOutputStream out = response.getOutputStream();	
		byte[] abyte = json.getBytes("UTF-8");	
		response.setContentLength(abyte.length);
		out.write(abyte);					
		out.flush();
	}

	

	
	
	
}
