package it.softecspa.fileproxy.services.common.core.response.body;

import it.softecspa.fileproxy.services.common.core.BodyResponseException;
import it.softecspa.fileproxy.services.common.core.response.XMLResponseKO;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.servlet.ServletOutputStream;

public class ErrorBodyXML extends ErrorBody {

	@Override
	protected void write() throws IOException, BodyResponseException {
		
		byte[] abyte;
		try {
			XMLResponseKO xml = new XMLResponseKO(myReturn.getCode(),myReturn.getMessage());
			xml.applyCData();
			abyte = xml.generateXML("UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new BodyResponseException(e);
		}
		
		response.setCharacterEncoding("UTF-8");
		response.setContentType("text/xml");
		
		ServletOutputStream out = response.getOutputStream();	
		
		response.setContentLength(abyte.length);
		out.write(abyte);					
		out.flush();
	}

	

	
	
	
}
