package it.softecspa.fileproxy.services.common.core.response.body;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import it.softecspa.fileproxy.services.common.UniversalStatementException;
import it.softecspa.fileproxy.services.common.core.BodyResponseException;
import it.softecspa.fileproxy.services.common.core.MyHttpServletResponse;
import it.softecspa.fileproxy.services.common.core.MyReturn;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

public abstract class MyBody {

	protected Logger log = Logger.getLogger(getClass());

	protected HttpServletRequest request;
	protected HttpServletResponse response;
	protected MyReturn myReturn;
	
	protected boolean gzip;
	protected boolean nocache;

	protected MyBody() {
		super();
	}
	
	protected MyBody(boolean nocache) {
		super();
		this.nocache = nocache;
	}

	public void write(MyHttpServletResponse myresponse) throws IOException, BodyResponseException {
		request = myresponse.getHttpServletRequest();
		response = myresponse.getHttpServletResponse();

		/* 
		 * m.veroni, test del 2012-10-08
		 * Il chiamante pu gestire le comunicazioni compresse?
		 * 
		 * String acceptEncoding = request.getHeader("Accept-Encoding");
		 * boolean gzip = (acceptEncoding!=null && acceptEncoding.contains("gzip"));
		 * 
		 * Volutamente messo a FALSE in quanto si  visto un forte rallentamento nella comunicazione
		 * Questa cosa  stata vista in particolar modo su sistemi IOS
		 * 
		 */
		gzip = false;
		
		if (nocache) {
			if (log.isDebugEnabled()) log.debug("Response --> Cache-Control: no-cache");
			
			// NO-CACHE
	        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
	        response.setHeader("Pragma", "no-cache"); // HTTP 1.0.
	        response.setDateHeader("Expires", 0); // Proxies.
		}
		
		write();
	}

	
	protected abstract void write() throws IOException, BodyResponseException;
	
	
	/**
	 * Scrive nel BODY della response http il file in attachment
	 * @param response
	 * @param file
	 * @throws IOException
	 * @throws UniversalStatementException
	 */
	protected void writeFileGeneric(File file, int chunksize) throws IOException, BodyResponseException {
		ServletOutputStream out = response.getOutputStream();	
		
		FileInputStream fis=null;
		try {
			try {
				fis = new FileInputStream(file);
			} catch (FileNotFoundException e) {
				log.error("File not found: '"+file.getAbsolutePath()+"'");
				throw new BodyResponseException(e);
			}

			response.setContentLength((int) file.length());
			
			if (chunksize<=0) {
				int len = (int) file.length();
				byte abyte[] = new byte[len];
				fis.read(abyte);
				out.write(abyte,0,len);
				out.flush();
			
			} else {
				// Copia i file nelle stream a blocchi di ...
				if (log.isDebugEnabled()) log.debug("Chunked transmission with size of "+chunksize+"K");
				
				int len = -1;
				byte abyte[] = new byte[chunksize];
				while (!((len = fis.read(abyte))==-1)) {
					out.write(abyte,0,len);
					out.flush();
				}	
			}
			
		} finally {
			try {
				if (fis!=null) fis.close();
			} catch (Exception e) {
				/* Nessuna operazione */
			}
		}
		
	}

	public void setMyReturn(MyReturn myReturn) {
		this.myReturn = myReturn;
	}
	

}
