package it.softecspa.fileproxy.util;

import java.lang.reflect.Array;

import org.apache.log4j.Logger;

public class ArrayCopy {

	private static Logger log = Logger.getLogger(ArrayCopy.class);
	
	
	/**
	 * Concateno tutti i parametrie estratti
	 * @param list
	 * @return
	 */
	public static <K> K[] buildAll(Class<K> clazz, K[] ... list) {
		if (list==null) return null;
		if (list.length==1) return list[0];
		if (log.isDebugEnabled()) log.debug("Build unique service list from "+list.length+" sublist: class "+clazz.getName());
		
		int l=0;
		for (K[] element : list) {
			if (element==null) continue;
			l += element.length;
		}
		
		if (log.isDebugEnabled()) log.debug("Build new list of "+l+" elements");
		@SuppressWarnings("unchecked")
		K[] services = (K[]) Array.newInstance(clazz, l) ;
		
		
		int start = 0;
		for (K[] element : list) {
			if (element==null) continue;
			System.arraycopy(element, 0, services, start, element.length);
			start += element.length;
		}

		return services;
	}
	
}
