package it.softecspa.fileproxy.util;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.math.BigDecimal;

/**
 * Classe per la conversione dei tipi da e verso le chiamta webservice
 * 
 * @author m.veroni *
 */
public class Convert {

	public static Integer toInteger(String value) {
		if (XString.isNotBlankNull(value))
			return new Integer(value);
		return null;
	}

	public static String toString(Integer value) {
		if (value != null)
			return value.toString();
		return null;
	}

	public static int toIntValue(String value) {
		if (XString.isNotBlankNull(value))
			return new Integer(value).intValue();
		return 0;
	}

	public static String toString(int value) {
		return "" + value;
	}

	public static Long toLong(String value) {
		if (XString.isNotBlankNull(value))
			return new Long(value);
		return null;
	}

	public static String toString(Long value) {
		if (value != null)
			return value.toString();
		return null;
	}

	public static long toLongValue(String value) {
		if (XString.isNotBlankNull(value))
			return new Long(value).longValue();
		return 0;
	}

	public static String toString(long value) {
		return "" + value;
	}

	public static BigDecimal toBigDecimal(String value) {
		if (XString.isNotBlankNull(value))
			return new BigDecimal(value);
		return null;
	}

	public static String toString(BigDecimal value) {
		if (value != null)
			return value.toString();
		return null;
	}

	
	/**
	 * @deprecated
	 * @param value
	 * @return
	 * @throws Exception
	 */
	public static EnterpriseCalendar toEnterpriseCalendar(String value) throws Exception {
		if (XString.isNotBlankNull(value)) return new EnterpriseCalendar(value, EnterpriseCalendar.PATTERNS_UTC);
		return null;
	}

	
	public static String toString(EnterpriseCalendar value) {
		if (value != null)
			return value.format(EnterpriseCalendar.PATTERN_UTC_ZULU);
		return null;
	}

	public static String cdata(String value) {
		if (XString.isNotBlankNull(value)) return "<![CDATA["+value+"]]>";
		return "";
	}
	
}
