package it.softecspa.fileproxy.util;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

/**
 * Classe di utilit spicciola
 * @author m.veroni
 */
public class If {
	
	public static Integer notNull(Integer check, Integer value) {
		if (check!=null) return check;
		return value;
	}
	
	/**
	 * @deprecated
	 */
	public static Integer notNull(Integer check) {
		return notNull(check, (Integer)null);
	}
	
		
	
	public static String notNull(String check, String value) {
		if (XString.isNotBlankNullTrim(check)) return check;
		return value;
	}
	
	/**
	 * @deprecated
	 */
	public static String notNull(String check) {
		return notNull(check, (String)null);
	}
	
	
	public static EnterpriseCalendar notNull(EnterpriseCalendar check, EnterpriseCalendar value) {
		if (check!=null) return check;
		return null;
	}
	
	/**
	 * @deprecated
	 */
	public static EnterpriseCalendar notNull(EnterpriseCalendar check) {
		return notNull(check, (EnterpriseCalendar)null);
	}
	
	public static String notNull(Object check, String value) {
		if (check!=null) return check.toString();
		return value;
	}
	
	/**
	 * @deprecated
	 */
	public static String notNull(Object check) {
		return notNull(check, (String)null);
	}
	
	
	public static boolean notNull(Boolean check, boolean value) {
		if (check!=null) return check.booleanValue();
		return value;
	}
	
	public static boolean notNull(Boolean check) {
		return notNull(check, false);
	}
	
	
}