package it.softecspa.fileproxy.util;

import it.softecspa.fileproxy.services.common.CheckerException;
import it.softecspa.fileproxy.services.common.ResponseOutcome;
import it.softecspa.kahuna.lang.XString;

public class Size {

	public int width;
	public int height;

	public Size(String dimensioni) throws CheckerException {
		if (XString.isBlankNullTrim(dimensioni)) {
			throw new CheckerException(ResponseOutcome.VIEWSIZE_NO_VALID_VALUE);
		}

		dimensioni = dimensioni.toLowerCase(); // normalizzazione
		String[] wxh = dimensioni.split("x");
		if (wxh.length != 2) {
			throw new CheckerException(ResponseOutcome.VIEWSIZE_NO_VALID_VALUE);
		}

		try {
			this.width = Integer.parseInt(wxh[0]);
			this.height = Integer.parseInt(wxh[1]);
		} catch (NumberFormatException e) {
			throw new CheckerException(ResponseOutcome.VIEWSIZE_NO_VALID_VALUE, e.toString());
		}
	}

	public Size(int width, int height) {
		this.width = width;
		this.height = height;
	}

	public String toString() {
		return width + "x" + height;
	}
}