package it.softecspa.fileproxy.util;

import it.softecspa.kahuna.lang.XString;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

public class VersionComparator {

	private Logger log = Logger.getLogger(getClass());
	private Integer normalized;
	
	
	public VersionComparator(String version) {
		normalized = normalize(version);
		if (normalized==null) throw new NullPointerException();
	}


	private Integer normalize(String appVersion) {
		if (XString.isBlankNullTrim(appVersion)) return null;
		
		String v = null;
		try {
			Pattern pattern = Pattern.compile("\\d+[\\.\\d+]+");
			Matcher matcher = pattern.matcher(appVersion);
			
			if (matcher.find())	{
				v = matcher.group(0);
				if (log.isDebugEnabled()) log.debug("Match pattern find record: '"+v+"'");
			}
		} catch (Exception e) {
			log.warn("Error match patter in check version");
			v = appVersion;
		}
		
		if (v==null) return null;
		return build(v);
	}
	
	
	private Integer build(String v) {
		String[] s = v.split("\\.");
		if (s.length==0) return null;
		int device_version=0;
		try {
			if (s.length==3) {
				device_version = (((Integer.parseInt(s[0])*1000) + Integer.parseInt(s[1]))*1000) + Integer.parseInt(s[2]);
			} else if (s.length==2) {
				device_version = (((Integer.parseInt(s[0])*1000) + Integer.parseInt(s[1]))*1000);
			} else if (s.length==1) {
				device_version = ((Integer.parseInt(s[0])*1000)*1000);
			} else if (s.length>3) {
				device_version = (((Integer.parseInt(s[0])*1000) + Integer.parseInt(s[1]))*1000) + Integer.parseInt(s[2]);
			}
		} catch (NumberFormatException e) {
			log.error("NumberFormatException splitting version number: '"+v+"'");
			return null;
		}
		return device_version;
	}
	
	private Integer build(int m, int s, int r) {
		return new Integer((((m*1000) + s)*1000) + r);
	}
	
	
	
	public boolean greaterThan(int m, int s, int r) {
		return (normalized>build(m,s,r));
	}
	
	public boolean greaterThan(String version) {
		if (version==null) throw new NullPointerException();
		return (normalized>normalize(version));
	}

	public boolean greaterThan(VersionComparator version) {
		return (normalized>version.normalized);
	}
	
	
	public boolean greaterThanOrEqual(int m, int s, int r) {
		return (normalized>=build(m,s,r));
	}
	
	public boolean greaterThanOrEqual(String version) {
		if (version==null) throw new NullPointerException();
		return (normalized>=normalize(version));
	}

	public boolean greaterThanOrEqual(VersionComparator version) {
		return (normalized>=version.normalized);
	}
	
}
