package it.softecspa.portal;

import it.softecspa.fileproxy.DatabaseBalancer;
import it.softecspa.fileproxy.services.ClusterSynchronizer;
import it.softecspa.fileproxy.services.ServerCacheFactory;
import it.softecspa.mvc.WebApp;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;



/**
 * Classe di visibilit ed utilit generale per tutta la initWebApp
 */
@SuppressWarnings("serial")
public class InitWebApp extends WebApp {

	
	
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		try {
			
			log.info("WebApp. Initialization with InitWebApp.");
			
			//...inserire qui il codice di configurazione custom dell'applicazione!
			
			
			/*
			 * 1) Chiamata utilizzata soltanto per caricare il singleton
			 * Bilanciatore database
			 * Sono bufferizzate le connessioni ai database MASTER e STAGE
			 * sia in lettura/scrittura che in sola lettura
			 * 
			 * - Questo servizio dipende da DatabaseManager
			 */
			if (log.isDebugEnabled()) log.debug("Create instance of " + DatabaseBalancer.class + " service");
			DatabaseBalancer databaseBalancer = DatabaseBalancer.getInstance();
					
			
			/*
			 * 2) Chiamata utilizzata soltanto per caricare il singleton
			 * Caricamento delle strutture dati in cache
			 * 
			 * - Questo servizio dipende da DatabaseBalancer 
			 */
			if (databaseBalancer.isActive()) {
				if (log.isDebugEnabled()) log.debug("Create instance of " + ServerCacheFactory.class + " service");
				ServerCacheFactory.getInstance();			
			}					
			
			
			
			/* 
			 * 3) Chiamata utilizzata per caricare il singleton ed effettuare la prima registrazione
			 * Gestore cluster
			 * Il sistema registra se stesso nel "registro" dei cluster 
			 * e attiva il thread "HeartBeat"
			 * 
			 * - Questo servizio dipende da DatabaseBalancer
			 */		
			if (databaseBalancer.isActive()) {
				if (log.isDebugEnabled()) log.debug("Create instance of " + ClusterSynchronizer.class + " service");
				ClusterSynchronizer.getInstance().init();
			}
						
			
			
			
			// ------------------------------------------------------------------------
			// Tracciamento dei riavvi dei nodi su log specifico, DESTROY
			traceReload("PUBLISH");
			// ------------------------------------------------------------------------
			
			
			
			
			
			
			// -------------------------------------------------------------------------------------------------
			log.info("WebApp. Initialization completed with success.");
		} catch (Exception e) {
			log.error("ERROR: Impossibile to complete WebApp initailization!",e);
		} finally {
			//log.info("--------------------------------------------------------------------------------");
		}
		
	}
	
	
	
	public void destroy() {
		/*
		...inserire qui il codice custom
		*/	
		try {
			ClusterSynchronizer.getInstance().endLife();
		} catch (Exception e) {
			log.error("Error write end life",e);
		}
		
		// ------------------------------------------------------------------------
		// Tracciamento dei riavvi dei nodi su log specifico, DESTROY
		traceReload("DESTROY");
		// ------------------------------------------------------------------------
					
		super.destroy();
	}
	
	
	private void traceReload(String status) {
		// ------------------------------------------------------------------------
		// Tracciamento dei riavvi dei nodi su log specifico, DESTROY
		Parameters parameters = Parameters.getInstance();
		Version versione = Version.getInstance();
		String installation = parameters.get(Parameters.APPLICATION_ENVIRONMENT);
		String hostname = ApplicationClusterInfo.getInstance().getHostNameAddress();
		Logger.getLogger("reload").info(parameters.getChannelInfo().getApplicationTitle() +" "+ status + " - Versione " + versione.toString() + " (" + installation + ")" + (hostname != null ? " on host " + hostname : ""));
		// ------------------------------------------------------------------------
	}
	
}
