package it.softecspa.portal.filters;

import it.softecspa.kahuna.lang.XString;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

public class DayReportFilter implements Filter {

	private Logger log = Logger.getLogger(getClass());
	private final String FILTER = "/dailyreport";
	
    @Override
    public void init(FilterConfig config) throws ServletException {
        //
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;
        // NO-CACHE
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
        response.setHeader("Pragma", "no-cache"); // HTTP 1.0.
        response.setDateHeader("Expires", 0); // Proxies.
        //
        String requestURI = request.getRequestURI();
        int i = requestURI.indexOf(FILTER); 
        if (i>=0) {     
        	
        	String appo = requestURI.substring(i+FILTER.length());
        	if (appo.startsWith("/")) appo = appo.substring(1);
        	if (appo.startsWith("?")) appo = appo.substring(1);
        	if (!"".equals(appo) && !appo.startsWith("&")) appo = "&" + appo;
        	
        	String newURI = "/portal-service-guest/statement?daily-report&noMail=1" + appo;
            if (XString.isNotBlankNull(request.getQueryString())) {
            	newURI += "&" + request.getQueryString();
            }
            
        	if (log.isDebugEnabled()) log.debug("Filter url '"+requestURI+"', forward to '"+newURI+"'");
        	req.getRequestDispatcher(newURI).forward(req, res);
        } else {
            chain.doFilter(req, res);
        }
    }

    @Override
    public void destroy() {
        //
    }
}