package it.softecspa.portal.filters;

import it.softecspa.kahuna.lang.XString;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

public class ShareFilter implements Filter {

	private Logger log = Logger.getLogger(getClass());
	private final String FILTER_SHARE 		= "/share/";
	private final String FILTER_SHARE_FRAME = "/share/frame/";
	private final String FILTER_INCLUDE 	= "/share/include/";
	
	public static String SID 		= "sid";
	public static String UID 		= "uid";
	public static String SESSIONID 	= "t";
	public static String INSTANCE 	= "i";
	public static String GROUP 		= "g";
	public static String CONFIG 	= "c";
	public static String FRAME 		= "f";
	public static String DEVICE		= "d";
	
	
	
    @Override
    public void init(FilterConfig config) throws ServletException {
        //
    }
    
    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;
        // NO-CACHE
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
        response.setHeader("Pragma", "no-cache"); // HTTP 1.0.
        response.setDateHeader("Expires", 0); // Proxies.
        //
        String requestURI = request.getRequestURI();
        
        // Pagina 3 - pagina con IFRAME
        int i = requestURI.indexOf(FILTER_INCLUDE); 
        if (i>=0) {     
        	String uid = requestURI.substring(i+FILTER_INCLUDE.length());
        	
        	String newURI = "/dmshare/include.jsp?" + UID + "=" + uid;
        	if (XString.isNotBlankNull(request.getQueryString())) {
            	newURI += "&" + request.getQueryString();
            }
        	if (log.isDebugEnabled()) log.debug("Filter url '"+requestURI+"' with frame, forward to '"+newURI+"'");
            req.getRequestDispatcher(newURI).forward(req, res);
            return;
        }
        
        // Pagina 2 - pagina con IFRAME
        i = requestURI.indexOf(FILTER_SHARE_FRAME); 
        if (i>=0) {     
        	String uid = requestURI.substring(i+FILTER_SHARE_FRAME.length());
        	
        	String newURI = "/dmshare/index.jsp?" + UID + "=" + uid + "&" +FRAME + "=1";
        	if (XString.isNotBlankNull(request.getQueryString())) {
            	newURI += "&" + request.getQueryString();
            }
        	if (log.isDebugEnabled()) log.debug("Filter url '"+requestURI+"' with frame, forward to '"+newURI+"'");
            req.getRequestDispatcher(newURI).forward(req, res);
            return;
        }
        
        // Pagina 1 - pagina standard
        i = requestURI.indexOf(FILTER_SHARE); 
        if (i>=0) {  
        	String uid = requestURI.substring(i+FILTER_SHARE.length());
        	
        	String newURI = "/dmshare/index.jsp?" + UID + "=" + uid;
        	if (XString.isNotBlankNull(request.getQueryString())) {
            	newURI += "&" + request.getQueryString();
            }
        	if (log.isDebugEnabled()) log.debug("Filter url '"+requestURI+"', forward to '"+newURI+"'");
            req.getRequestDispatcher(newURI).forward(req, res);
            return;
        } 
        
        
    
        // ..sessun match!
        chain.doFilter(req, res);
    }

    @Override
    public void destroy() {
        //
    }
}