package it.softecspa.portal.filters;

import it.softecspa.kahuna.lang.XString;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

public class StoreFilter implements Filter {

	private Logger log = Logger.getLogger(getClass());
	private final String FILTER = "/store/";
	
    @Override
    public void init(FilterConfig config) throws ServletException {
        //
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;
        // NO-CACHE
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
        response.setHeader("Pragma", "no-cache"); // HTTP 1.0.
        response.setDateHeader("Expires", 0); // Proxies.
        //
        String requestURI = request.getRequestURI();
        int i = requestURI.indexOf(FILTER); 
        if (i<0) {
        	chain.doFilter(req, res);
        	return;
        }
        if (requestURI.endsWith(FILTER)) {
        	// FIXME mica ci passa mai di qui!!!!!
        	// ...questo per accettare anche l'indirizzo con /
        	req.getRequestDispatcher("/store").forward(req, res);
        	return;
       }
        
        
    	/*
    	 * TODO
    	 * aggiungre lettura filtri ?auto
    	 * da passare quando il download avviene da un servizio
    	 * 
    	 * tramutare tutti i ? in & 
    	 * 
    	 * in caso di mancanza del parametro il sistema verifica se:
    	 * 1) andare ugualmente a diritto
    	 * 2) richiedere password specifica
    	 * 3) richiedere autenticazione SSO
    	 * 
    	 * 
    	 */       	
    	
    	String newURI = "/dmstore/target.jsp?path=" + requestURI.substring(i+FILTER.length());
        if (XString.isNotBlankNull(request.getQueryString())) {
        	newURI += "&" + request.getQueryString();
        }
        
    	if (log.isDebugEnabled()) log.debug("Filter url '"+requestURI+"', forward to '"+newURI+"'");
    	req.getRequestDispatcher(newURI).forward(req, res);
 
    }

    @Override
    public void destroy() {
        //
    }
}