package it.softecspa.portal.security;


import it.softecspa.mvc.businesslogic.KeyStore;

import java.util.HashMap;

/**
 * E' il contenitore di chiavi cablate nell'applicazione. Da defaultImplementation
 * Prevede che ci siano almeno due chiavi chiamate come segue:
 * <ul>
 *  <li> chiaveCifraturaSimmetrica
 *  <li> chiaveCifraturaPassword
 * </ul>
 */
public class KeyStoreImpl implements KeyStore {

    private HashMap<String, String> keyStore = new HashMap<String, String>();
    
    /**
     * Chiave di cifratura di dati (che arrivano da applicazioni esterne)
     */
    private static final String chiaveCifraturaSimmetrica = "|||||||||||RIDEFINIRE||||||||||||";
    
    /**
     * Chiave di cifratura della password degli utenti
     */
    private static final String chiaveCifraturaPassword = "|||||||||||RIDEFINIRE||||||||||||";
    
    public KeyStoreImpl() {
        keyStore.put(KeyStore.CHIAVE_SIMMETRICA_LABEL,chiaveCifraturaSimmetrica);
        keyStore.put(KeyStore.CHIAVE_PASSWORD_LABEL,chiaveCifraturaPassword);
    }
    
    /**
     * @see it.softecspa.mvc.businesslogic.KeyStore#getKey(java.lang.String)
     */
    public String getKey(String chiave) {
        return (String)keyStore.get(chiave);
    }

    
    
}
