package it.softecspa.database.dbconnect;

import java.util.Calendar;
import java.util.Date;

class DBMS_MySql extends DBMS {

	protected String toSQLDate(Date d) {
		if (d == null)
			return "NULL";
		return "CAST('" + DATE_FORMAT.format(d) + "' AS DATE)";
	}

	protected String toSQLDateTime(Date d) {
		if (d == null)
			return "NULL";
		return "CAST('" + DATETIME_FORMAT.format(d) + "' AS DATETIME)";
	}

	protected String funCurrentDate() {
		return "CURDATE()";
	}

	protected String funCurrentDateTime() {
		return "NOW()";
	}

	protected String toSQLDate(Calendar d) {
		if (d == null)
			return "NULL";
		return "CAST('" + DATE_FORMAT.format(d.getTime()) + "' AS DATE)";
	}

	protected String toSQLDateTime(Calendar d) {
		if (d == null)
			return "NULL";
		return "CAST('" + DATETIME_FORMAT.format(d.getTime()) + "' AS DATETIME)";
	}

	
	@Override
	protected DatabaseError decodeError(int errorCode) {
		if (errorCode==1062) return DatabaseError.DUPLICATE_ENTRY;
		if (errorCode==1146) return DatabaseError.NO_SUCH_TABLE;
		
		return DatabaseError.UNHANDLED; 
	}
}
