package it.softecspa.database.dbconnect;

import java.util.Calendar;
import java.util.Date;

class DBMS_Oracle extends DBMS {

	protected String toSQLDate(Date d) {
		if (d == null)
			return "NULL";
		return "TO_DATE('" + DATE_FORMAT.format(d) + "', 'YYYY-MM-DD')";
	}

	protected String toSQLDateTime(Date d) {
		if (d == null)
			return "NULL";
		return "TO_DATE('" + DATE_FORMAT.format(d) + "', 'YYYY-MM-DD HH:mm:ss')";
	}

	protected String toSQLDate(Calendar d) {
		if (d == null)
			return "NULL";
		return "TO_DATE('" + DATE_FORMAT.format(d) + "', 'YYYY-MM-DD')";
	}

	protected String toSQLDateTime(Calendar d) {
		if (d == null)
			return "NULL";
		return "TO_DATE('" + DATE_FORMAT.format(d) + "', 'YYYY-MM-DD HH:mm:ss')";
	}

	protected String funCurrentDate() {
		return "SYSDATE";
	}

	protected String funCurrentDateTime() {
		return "SYSDATE";
	}
	
	
	@Override
	protected DatabaseError decodeError(int errorCode) {
		//if (errorCode==) return DatabaseError.DUPLICATE_ENTRY;
		//if (errorCode==) return DatabaseError.NO_SUCH_TABLE;
		
		return DatabaseError.UNHANDLED; 
	}
	
}
