package it.softecspa.database.dbconnect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.log4j.Logger;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatement;
import it.softecspa.database.dbconnect.DBMS.DatabaseError;

public class DatabaseStatementUnplugged {

	Logger log = Logger.getLogger(DatabaseStatementUnplugged.class);	
	private DatabaseStatement dbs;
	private boolean dbsuTransitorio; 
	
	
	
	private DatabaseStatementUnplugged(ConnectionManager cm, boolean forUpdate) throws SQLException {
		dbs = new DatabaseStatement(cm, forUpdate);
		dbsuTransitorio = false;
	}
	
	/**
	 * Restituisce una istanza di {@link DatabaseStatementUnplugged}
	 * @param cm
	 * @return
	 * @throws SQLException
	 */
	public static DatabaseStatementUnplugged getInstance(ConnectionManager cm) throws SQLException {
		return new DatabaseStatementUnplugged(cm, true);		
	}
	
	/**
	 * Restituisce una istanza dello statement specificando se quiesto  transazionale o meno
	 * @param cm
	 * @param transazionale
	 * @return
	 * @throws SQLException
	 */
	public static DatabaseStatementUnplugged getInstanceAUTOCOMMIT(ConnectionManager cm) throws SQLException {
		return new DatabaseStatementUnplugged(cm, false);		
	}
	
	/**
	 * @deprecated
	 * Restituisce una istanza dello statement specificando se questo  transazionale o meno
	 * Sotituit con altre choamte specifiche
	 * @param cm
	 * @param transazionale
	 * @return
	 * @throws SQLException
	 */
	public static DatabaseStatementUnplugged getInstance(ConnectionManager cm, boolean transazionale) throws SQLException {
		return new DatabaseStatementUnplugged(cm, transazionale);		
	}

	
	
	private DatabaseStatementUnplugged(DatabaseStatement dbs) {
		this.dbs = dbs;
		dbsuTransitorio = true;
	}

	/**
	 * Restituisce una istanza di {@link DatabaseStatementUnplugged} a partire da un {@link DatabaseStatement}
	 * @param dbs
	 * @return
	 * @throws SQLException
	 */
	public static DatabaseStatementUnplugged getInstance(DatabaseStatement dbs) throws SQLException {
		return new DatabaseStatementUnplugged(dbs);		
	}
	
	
	
	
	
	/**
	 * @deprecated
	 * @throws SQLException
	 */
	public void closeWithCommit() throws SQLException {
		dbs.commit();
	}
	
	public void commit() throws SQLException {
		dbs.commit();
	}
	
	/**
	 * @deprecated
	 * @throws SQLException
	 */
	public void closeWithRollback() throws SQLException {
		dbs.rollback();
	}
	
	public void rollback() throws SQLException {
		dbs.rollback();
	}
	
	
	
	/**
	 * Restituisce un ResulSet aperto sul DatabaseStatement
	 * @param sql
	 * @return
	 * @throws SQLException
	 */
	public ResultSet getResultSet(String sql) throws SQLException {
		return dbs.getResultSet(sql);
	}
	
	public ResultSet getResultSet(String sql, int fetchSizeRows) throws SQLException {
		return dbs.getResultSet(sql, fetchSizeRows);
	}
	
	
	/**
	 * Esegue il comando sql
	 * @param sql
	 * @return
	 * @throws SQLException
	 */
	public int execute (String sql) throws SQLException {
		return dbs.execute(sql);
	}
	
	
	
	/**
	 * Utilizzare il metodo free
	 * @throws SQLException
	 */
	protected void close() throws SQLException {
		if (dbsuTransitorio) return;
		
		dbs.close();
	}
	
	
	
	/**
	 * Restitutisce l'istanza del {@link DatabaseStatement}
	 * @return
	 */
	public DatabaseStatement getDatabaseStatement() {
		return dbs;
	}
	
	
	public void free() {
		if (dbsuTransitorio) return;
		
		
		if (dbs!=null) {
			try {
				rollback();
			} catch (SQLException e) {
				log.warn("Unhandled SQLException closing DBS: " + e.toString());
			}
		}
		try {
			dbs.close();
		} catch (Exception e) {
			/* Nessuna operazione */
		}
		
		// libero la risorsa
		dbs=null;
	}
	
	
	protected void finalize() {
		free();
	}
	
	
	
	
	/**
     * Retrieves a <code>DatabaseMetaData</code> object that contains
     * metadata about the database to which this
     * <code>Connection</code> object represents a connection.
     * The metadata includes information about the database's
     * tables, its supported SQL grammar, its stored
     * procedures, the capabilities of this connection, and so on.
     *
     * @return a <code>DatabaseMetaData</code> object for this 
     *         <code>Connection</code> object
     * @exception SQLException if a database access error occurs
     */
	public DatabaseMetaData getMetadata() throws SQLException {
		return dbs.getMetaData();
	}
	
	
	/**
     * Retrieves this <code>Connection</code> object's current catalog name.
     *
     * @return the current catalog name or <code>null</code> if there is none
     * @exception SQLException if a database access error occurs
     * @see #setCatalog
     */
	public String getCatalog() throws SQLException {
		return dbs.getCatalog();
	}
		
	
	public Connection getConnection() {
		return dbs.getConnection();
	}
	
	/**
	 * @deprecated
	 * @return
	 */
	public ConnectionManager getConnectionManager() {
		return dbs.getConnectionManager();
	}
	
	public ConnectionManager getReadOnlyConnectionManager() {
		return dbs.getConnectionManager();
	}
	
	
	
	public boolean isHideQueryLog() {
		return dbs.isHideQueryLog();
	}
	
	public void hideQueryLog() {
		dbs.hideQueryLog();
	}
	
	public void unhideQueryLog() {
		dbs.unhideQueryLog();
	}
	
	
	/**
	 * Esegue un confronto tra il codice di errore restituito e quello desiderato
	 * @param errorCode
	 * @param check
	 * @return
	 */
	public boolean checkError(int errorCode, DatabaseError check) {
		return dbs.getDBMS().checkError(errorCode,check);
	}
	
	/**
	 * Verifca se l'eccezione SQL equivale all'errore desiderato
	 * @param errorCode
	 * @param check
	 * @return
	 */
	public boolean checkError(SQLException e, DatabaseError check) {
		return dbs.getDBMS().checkError(e.getErrorCode(), check);
	}
	
	
}
