package it.softecspa.database.dbconnect;

import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @deprecated Una implementazione di <code>Row</code> utile per estrarre dal
 *             database una lista di oggetti che posseggono una descrizione e
 *             sono identificati da un numero intero.
 * 
 * @author Gino Quaglietta
 */

public class ListItem extends Row {
	/**
	 * codice dell'oggetto
	 */
	public int cod = 0;
	/**
	 * descrizione dell'oggetto
	 */
	public String description = null;

	/**
	 * Costruisce un nuovo oggetto <code>ListItem</code>.
	 */
	public ListItem() {
	}

	/**
	 * Costruisce un oggetto <code>ListItem</code> con gli attributi
	 * specificati.
	 * 
	 * @param cod
	 *            il codice dell'oggetto
	 * @param description
	 *            la descrizione dell'oggetto
	 */
	public ListItem(int cod, String description) {
		this.cod = cod;
		this.description = description;
	}

	/**
	 * Legge il codice e la descrizione dal <code>ResultSet</code>.
	 * 
	 * @param rs
	 *            l'oggetto <code>ResultSet</code> contenente il codice intero
	 *            come primo campo e la descrizione come secondo campo.
	 * @throws SQLException
	 *             se si verifica un errore di accesso al database
	 */
	protected void readRow(ResultSet rs) throws SQLException {
		cod = rs.getInt(1);
		description = rs.getString(2).trim();
	}

	/**
	 * Restituisce l'array <code>ListItem[]</code> selezionato dalla query
	 * utilizzando il <code>ConnectionManager</code> specificato.
	 * 
	 * @param cm
	 *            il <code>ConnectionManager</code> che deve essere utilizzato
	 * @param sql
	 *            la query che seleziona un insieme di righe contenente il
	 *            codice intero come primo campo e la descrizione come secondo
	 *            campo
	 * @return l'array <code>ListItem[]</code> selezionato dalla query
	 * @throws SQLException
	 *             se si verifica un errore di accesso al database
	 */
	public static ListItem[] getList(ConnectionManager cm, String sql) throws SQLException {
		return (ListItem[]) (new ListItem()).getRows(cm, sql);
	}

	/**
	 * Restituisce l'array <code>ListItem[]</code> selezionato dalla query
	 * utilizzando il <code>ConnectionManager</code> di default.
	 * 
	 * @param sql
	 *            la query che seleziona un insieme di righe contenente il
	 *            codice intero come primo campo e la descrizione come secondo
	 *            campo
	 * @return l'array <code>ListItem[]</code> selezionato dalla query
	 * @throws SQLException
	 *             se si verifica un errore di accesso al database
	 */
	public static ListItem[] getList(String sql) throws SQLException {
		return (ListItem[]) (new ListItem()).getRows(sql);
	}

	/**
	 * Restituisce <code>cod + " - " + description</code>
	 */
	public String toString() {
		return cod + " - " + description;
	}
}
