package it.softecspa.database.dbconnect.deprecated;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DBMS;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * @deprecated
 * Implementazione di un <code>ConnectionManager</code> che gestisce le
 * connessioni al database utilizzando il driver, la url e le credenziali di
 * accesso specificate.
 * <p>
 * Anche se l'applicazione deve utilizzare un proprio
 * <code>ConnectionManager</code>, questa implementazione  utile per effettuare
 * il test delle classi che gestiscono il database.
 * 
 * @author Gino Quaglietta
 */
class StandardConnectionManager extends ConnectionManager {
	private String url;
	private String user;
	private String password;

	/**
	 * Costruisce uno <code>StandardConnectionManager</code> che si connette al
	 * dbms utilizzando il driver, la url e le credenziali di accesso
	 * specificate.
	 * 
	 * @param dbms
	 *            una delle implementazioni di <code>DBMS</code> fornite da
	 *            {@link DBMS}
	 * @param driverName
	 *            il nome completo della classe driver; esempio:
	 *            <code>"com.mysql.jdbc.Driver"</code>
	 * @param url
	 *            la url del database, nella forma
	 *            <code>jdbc:<i>subprotocol</i>:<code>jdbc:<i>subname</i></code>
	 *            ; esempio: stringa di connessione; esempio:
	 * 
	 *            <pre>
	 * &quot;jdbc:mysql://servername/dbname&quot;
	 * </pre>
	 * @param user
	 *            l'utente del database
	 * @param password
	 *            la password dell'utente del database
	 * @throws ClassNotFoundException
	 *             se non trova la classe driver
	 */
	StandardConnectionManager(DBMS dbms, String driverName, String url, String user, String password) throws ClassNotFoundException {
		super(dbms);
		this.url = url;
		this.user = user;
		this.password = password;
		try {
			Class.forName(driverName);
		} catch (ClassNotFoundException e) {
			System.err.println("StandardConnectionManager:\n   Driver \"" + driverName + "\" non trovato");
			throw e;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	protected final Connection getConnection() throws SQLException {
		return DriverManager.getConnection(url, user, password);
	}

	/**
	 * {@inheritDoc}
	 */
	protected final void closeConnection(Connection con) throws SQLException {
		con.close();
	}

}
