package it.softecspa.database.reverser;

public class Arguments {

	enum Args {
		  TABLE_PREFIX			(0, new Integer(0))
		, BLOCK_ALONE_CHAR		(1, Boolean.TRUE)
		, STORE_ROOT			(2, "")
		, STORE_PACKAGE			(3, "")
		, DB_DRIVER				(4, "")
		, DB_URL				(5, "")
		, DB_USER				(6, "")
		, DB_PASSWORD			(7, "")
		, UPDATE_D_RECORD		(8, Boolean.FALSE)
		, DELETE_WITH_D_CANCEL	(9, Boolean.FALSE)
		, TABLE_REGX_INCLUDE	(10, "")
		, TABLE_REGX_EXCLUDE	(11, "")
		, FLUSH_ALL 			(12, Boolean.FALSE)
		, CLONABLE 				(13, Boolean.FALSE);

		private int index;
		private Object value;

		private Args(int index, Object value) {
			this.index = index;
			this.value = value;
		}

		public int getIndex() {
			return index;
		}

		public Object getValue() {
			return value;
		}
	}

	protected Object[] values;
	
	
	Arguments() {
		super();
		values = new Object[Args.values().length];
	}
	
	/*
	 * private int tablePrefix = 4;
	 * 
	 * private boolean blockAloneChar = true;
	 * 
	 * private String storeRoot = "./test"; private String storePackage =
	 * "it.softecspa.desktopmate.db";
	 * 
	 * private String dbDriver = "com.mysql.jdbc.Driver"; private String dbUrl =
	 * "jdbc:mysql://localhost:3306/web103db2?autoReconnect=true"; private
	 * String dbUser = "web103u2"; private String dbPassword = "GOoRoTj5K5";
	 * 
	 * 
	 * private boolean updateRecordTimestamp = true; private boolean
	 * deleteWithCancel = true;
	 */
	public Arguments(String[] args) throws ReverseException {
		this();
		
		if (args == null || args.length == 0) throw new ReverseException("Not valid argument");
		
		Args found = null;
		String parameter = null; 
		
		for (String value : args) {

			if (value.startsWith("-")) {
				if (found!=null) {
					throw new ReverseException("Not valid argument");
				}
				parameter = value;
				value = value.toLowerCase().substring(1);

				if (value.equals("u") || value.equals("user")) {
					// USER
					found = Args.DB_USER;

				} else if (value.equals("p") || value.equals("pass")) {
					// PASSWORD
					found = Args.DB_PASSWORD;

				} else if (value.equals("d") || value.equals("driver")) {
					// DRIVER
					found = Args.DB_DRIVER;

				} else if (value.equals("l") || value.equals("url")) {
					// URL
					found = Args.DB_URL;

				} else if (value.equals("r") || value.equals("root")) {
					// ROOT filesystem
					found = Args.STORE_ROOT;

				} else if (value.equals("g") || value.equals("pack")) {
					// Package
					found = Args.STORE_PACKAGE;

				} else if (value.equals("a") || value.equals("alone")) {
					// Block alone char
					found = Args.BLOCK_ALONE_CHAR;

				} else if (value.equals("t") || value.equals("tprefix")) {
					// Table prefix
					found = Args.TABLE_PREFIX;

				} else if (value.equals("dc") || value.equals("dcancel")) {
					// Delete with d_cancel
					found = Args.DELETE_WITH_D_CANCEL;

				} else if (value.equals("dr") || value.equals("drecord")) {
					// Update d_record
					found = Args.UPDATE_D_RECORD;
					
				} else if (value.equals("exf") || value.equals("exfilter")) {
					// REGX fron include table name
					found = Args.TABLE_REGX_INCLUDE;	
				
				} else if (value.equals("inf") || value.equals("infilter")) {
					// REGX for exclude table name
					found = Args.TABLE_REGX_EXCLUDE;	
					
				} else if (value.equals("flush")) {
					// FLUSH classes
					found = Args.FLUSH_ALL;	
				
				} else if (value.equals("clonable")) {
					// CLONABLE classes
					found = Args.CLONABLE;	
					
				} else {
					throw new ReverseException("Not valid parameter "+parameter);
				}

			} else {
				if (found==null) {
					throw new ReverseException("Not valid argument");
				}
				try {
					if (found.getValue() instanceof String) {
						values[found.getIndex()] = value;
						
					} else if (found.getValue() instanceof Boolean) {
						values[found.getIndex()] = Boolean.parseBoolean(value);
						
					} else if (found.getValue() instanceof Integer) {
						values[found.getIndex()] = Integer.parseInt(value);						
					}
				} catch (Exception e) {
					throw new ReverseException("Not valid value "+value+"  for parameter "+parameter);
				}
								
				found = null;
			}

		}

	}

	public static String getMessage() {
		String message = "Use this parameter to configure:\n" + 
						 "\n" + 
						 "-l  -url\t[url] mandatory\n" + 
						 "-u  -user\t[username] mandatory\n" + 
						 "-p  -pass\t[password] mandatory\n" + 
						 "-d  -driver\t[driver] mandatory\n" + 
						 "\n" + 
						 "-r  -root\t[path] mandatory\n" + 
						 "-g  -pack\t[package name] mandatory\n" + 
						 "\n" + 
						 "-a  -alone\t[true|false] default true\n" + 
						 "-t  -tprefix\t[n] default 0\n" + 
						 "-dc -dcancel\t[true|false] default false\n" + 
						 "-dr -drecord\t[true|false] default false\n" + 
						 "\n" +
						 "-inf -infilter\t[inclusion REGXS]\n" + 
						 "-exf -exfilter\t[exclusion REGXS]\n" +
						 "-flush [true|false] default false\n" +
						 "-clonable [true|false] default false\n" +
						 "\n";
		return message;
	}

	
	public int getTablePrefix() {
		return values[Args.TABLE_PREFIX.getIndex()]!=null?((Integer)values[Args.TABLE_PREFIX.getIndex()]).intValue():((Integer)Args.TABLE_PREFIX.getValue()).intValue();
	}
	
	
	public String getTableExcludeFilter() {
		return (String)values[Args.TABLE_REGX_INCLUDE.getIndex()];
	}

	public String getTableIncludeFilter() {
		return (String)values[Args.TABLE_REGX_EXCLUDE.getIndex()];
	}

	
	public boolean isBlockAloneChar() {
		return values[Args.BLOCK_ALONE_CHAR.getIndex()]!=null?((Boolean)values[Args.BLOCK_ALONE_CHAR.getIndex()]).booleanValue():((Boolean)Args.BLOCK_ALONE_CHAR.getValue()).booleanValue();
	}

	public String getStoreRoot() {
		return values[Args.STORE_ROOT.getIndex()]!=null?(String)values[Args.STORE_ROOT.getIndex()]:(String)Args.STORE_ROOT.getValue();
	}

	public String getStorePackage() {
		return values[Args.STORE_PACKAGE.getIndex()]!=null?(String)values[Args.STORE_PACKAGE.getIndex()]:(String)Args.STORE_PACKAGE.getValue();
	}

	public String getDbDriver() {
		return values[Args.DB_DRIVER.getIndex()]!=null?(String)values[Args.DB_DRIVER.getIndex()]:(String)Args.DB_DRIVER.getValue();
	}

	public String getDbUrl() {
		return values[Args.DB_URL.getIndex()]!=null?(String)values[Args.DB_URL.getIndex()]:(String)Args.DB_URL.getValue();
	}

	public String getDbUser() {
		return values[Args.DB_USER.getIndex()]!=null?(String)values[Args.DB_USER.getIndex()]:(String)Args.DB_USER.getValue();
	}

	public String getDbPassword() {
		return values[Args.DB_PASSWORD.getIndex()]!=null?(String)values[Args.DB_PASSWORD.getIndex()]:(String)Args.DB_PASSWORD.getValue();
	}

	public boolean isUpdateRecordTimestamp() {
		return values[Args.UPDATE_D_RECORD.getIndex()]!=null?((Boolean)values[Args.UPDATE_D_RECORD.getIndex()]).booleanValue():((Boolean)Args.UPDATE_D_RECORD.getValue()).booleanValue();
	}

	public boolean isDeleteWithCancel() {
		return values[Args.DELETE_WITH_D_CANCEL.getIndex()]!=null?((Boolean)values[Args.DELETE_WITH_D_CANCEL.getIndex()]).booleanValue():((Boolean)Args.DELETE_WITH_D_CANCEL.getValue()).booleanValue();
	}
	
	public boolean isFlush() {
		return values[Args.FLUSH_ALL.getIndex()]!=null?((Boolean)values[Args.FLUSH_ALL.getIndex()]).booleanValue():((Boolean)Args.FLUSH_ALL.getValue()).booleanValue();
	}
	
	public boolean isCloneable() {
		return values[Args.CLONABLE.getIndex()]!=null?((Boolean)values[Args.CLONABLE.getIndex()]).booleanValue():((Boolean)Args.CLONABLE.getValue()).booleanValue();
	}
	
}
