package it.softecspa.database.reverser;

import it.softecspa.database.dbconnect.Version;
import it.softecspa.database.reverser.util.TableInfo;
import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;

public abstract class Clazz {

	final String D_RECORD = "d_record";
	final String D_CANCEL = "d_cancel";
	final String F_DELETED = "f_deleted";
	
	
	Logger log = Logger.getLogger(getClass());
	Arguments arguments;
	
	final String TB = "\t";
	final String CR = "\r\n"; // (String)System.getProperties().get("line.separator");
	
	String packageName;
	String className;

	TableInfo metadata;

	String path;
	PrintWriter out;
	
	List<String> fieldsImport;
	List<String> othersImport;
	
	
	Clazz() {
		super();
		othersImport = new ArrayList<String>();
	}
	
	
	abstract void printGetterSetter();
	
	
	void printCommonHeader() {
		out.print("/*" + CR);
		out.print(" * @(#)"+className+".java" +TB+ new Version().toString() +TB+ EnterpriseCalendar.today().formatISO8601zulu() + " UTC" + CR);
		out.print(" * Built automatically by REVERSER" + CR);
		out.print(" */" + CR);
	}
	
	abstract void printHeader();
	
	void printImport() {
		
		// Riconciliazione degli import
		for (String value : fieldsImport) {
			if (!othersImport.contains(value)) othersImport.add(value);						
		}
		
		String[] orderImport = new String[othersImport.size()];
		othersImport.toArray(orderImport);
		Arrays.sort(orderImport);		
		String buffer=null;
		for (String value : orderImport) {
			String pack = "";
			int c=0;
			for (String frame : value.split("\\.")) {
				if (value.endsWith(frame)) continue;
				if (c>=2) continue;
				pack+=frame;
				c++;
			}
			
			if (!pack.equals(buffer)) {
				buffer=pack;
				out.print(CR);
			}								
			out.print("import "+value+";" + CR);			
		}
		out.print(CR);
	}
	
	abstract void printCostructors();
	abstract void printMethods();
	abstract void printFields();
	
	
	
	
	
	String sqlTypeCast(String prefisso, Class<?> javaType, String javaFieldName, boolean use_dbs) {
		String base = "";
		if (javaType.equals(String.class)) {
			base += prefisso + "sql.fStr(this."+javaFieldName+")";
		
		} else if (javaType.equals(Integer.class)) {
			base += prefisso + "sql.fNum(this."+javaFieldName+")";
			
		} else if (javaType.equals(Long.class)) {
			base += prefisso + "sql.fNum(this."+javaFieldName+")";
			
		} else if (javaType.equals(Double.class)) {	
			base += prefisso + "sql.fNum(this."+javaFieldName+")";
			
		} else if (javaType.equals(Float.class)) {	
			base += prefisso + "sql.fNum(this."+javaFieldName+")";
			
		} else if (javaType.equals(BigDecimal.class)) {	
			base += prefisso + "sql.fNum(this."+javaFieldName+")";
			
		} else if (javaType.equals(BigInteger.class)) {	
			base += prefisso + "sql.fNum(this."+javaFieldName+")";
			
		} else if (javaType.equals(Byte.class)) {	
			base += prefisso + "sql.fNum(this."+javaFieldName+")";	
			
		} else if (javaType.equals(Short.class)) {	
			base += prefisso + "sql.fNum(this."+javaFieldName+")";
			
		} else if (javaType.equals(EnterpriseCalendar.class)) {
			if (use_dbs) {
				base += prefisso + "Query.toSQLDateTime(dbs.getDBMS(), this."+javaFieldName+")";
			} else {
				base += prefisso + "Query.toSQLDateTime(this."+javaFieldName+")";
			}
		
		} else if (javaType.equals(Boolean.class)) {
			base += prefisso + "sql.fNum(this."+javaFieldName+"!=null?(this."+javaFieldName+".booleanValue()?1:0):null)";
		
		} else if (javaType.equals(byte[].class)) {	
			base = "/* FIXME correggere for type "+javaType.getName()+" */";
			
		} else {
			base = "/* FIXME correggere for type "+javaType.getName()+" */";
		}
		return base;
	}
	
	
	String resultsetGetCast(String rsName, Class<?> javaType, String columnName) {
		String base = "";
		if (javaType.equals(String.class)) {
			base += "rs.getString(\""+columnName+"\")";
		
		} else if (javaType.equals(Integer.class)) {
			base += "SqlWriter.getInteger("+rsName+", \""+columnName+"\")";
			
		} else if (javaType.equals(Long.class)) {
			base += "SqlWriter.getLong("+rsName+", \""+columnName+"\")";
			
		} else if (javaType.equals(Double.class)) {	
			base += "SqlWriter.getDouble("+rsName+", \""+columnName+"\")";
			
		} else if (javaType.equals(Float.class)) {	
			base += "SqlWriter.getFloat("+rsName+", \""+columnName+"\")";
			
		} else if (javaType.equals(BigDecimal.class)) {	
			base += "rs.getBigDecimal(\""+columnName+"\")";
			
		} else if (javaType.equals(BigInteger.class)) {	
			base += "rs.getBigInteger(\""+columnName+"\")";
			
		} else if (javaType.equals(Byte.class)) {	
			base += "SqlWriter.getByte("+rsName+", \""+columnName+"\")";
			
		} else if (javaType.equals(Short.class)) {	
			base += "SqlWriter.getShort("+rsName+", \""+columnName+"\")";
			
		} else if (javaType.equals(EnterpriseCalendar.class)) {
			base += "EnterpriseCalendar.newInstance(rs.getTimestamp(\""+columnName+"\"))";
		
		} else if (javaType.equals(Boolean.class)) {
			base += "SqlWriter.getBoolean("+rsName+", \""+columnName+"\")";
		
		} else if (javaType.equals(byte[].class)) {	
			base = "/* FIXME correggere for type "+javaType.getName()+" */";	
		
		} else {
			base = "/* FIXME correggere for type "+javaType.getName()+" */";
		}
		return base;
	}
	
	public String getName() {
		return packageName+"."+className;
	}
	
	public String getSimpleName() {
		return className;
	}
	
	public String getPackageName() {
		return packageName;
	}
	
	
	public TableInfo getMetadata() {
		return metadata;
	}
	
	
	void openPrintWriter(String root, boolean rewrite) throws ReverseException {
		path = root + "/" + XString.replaceAll(packageName, ".", "/");
		
		if (log.isDebugEnabled()) log.debug("Check path: "+path);
		File.checkMkdirs(this.path);

		File file = new File(this.path + "/" + className + ".java");
		if (file.exists() && !rewrite) {
			log.info("File "+file.getName()+" just exist; do not rewrite");
			
		} else {
			log.info("Writing class "+file.getName());
			try {
				out = new PrintWriter(file);
			} catch (IOException e) {
				throw new ReverseException("File not found",e);
			}
		}
	}
	
	
	void checkFieldsImport(Class<?> javaType) {
		
		if (javaType.equals(BigDecimal.class)) {	
			if (!fieldsImport.contains(BigDecimal.class.getName())) fieldsImport.add(BigDecimal.class.getName());
			
		} else if (javaType.equals(BigInteger.class)) {	
			if (!fieldsImport.contains(BigInteger.class.getName())) fieldsImport.add(BigInteger.class.getName());	
		
		} else if (javaType.equals(EnterpriseCalendar.class)) {
			if (!fieldsImport.contains(EnterpriseCalendar.class.getName())) fieldsImport.add(EnterpriseCalendar.class.getName());			
		}
		
	}
	
	boolean checkDRecord(String name) {
		return (name.equalsIgnoreCase(D_RECORD) && arguments.isUpdateRecordTimestamp());
	}
	
	boolean checkDCancel(String name) {
		return (name.equalsIgnoreCase(D_CANCEL) && arguments.isDeleteWithCancel());
	}
	
	

	public Arguments getArguments() {
		return arguments;
	}

	
	
	/**
	 * Crea il nome della classe a partire dal nome della tabella secondo le regole passate nei parametri
	 * @param name
	 * @return
	 */
	String createClassName(String name) {
		if (arguments.getTablePrefix() > 0) {
			name = name.substring(arguments.getTablePrefix());
		}
		
		name = XString.replaceAll(name, "_", " ");
		name = XString.replaceAll(name, "-", " ");
		name = XString.replaceAll(name, ".", " ");
		name = name.trim();

		// Prima lettera maiuscola
		name = XString.toUpperCaseFirst(name.toLowerCase());

		// Maiuscolo dopo lo spazio/underscore
		int i = 0;
		StringBuffer appoggio = new StringBuffer();

		while ((i = name.indexOf(" ")) >= 0) {
			appoggio.append(name.substring(0, i));
			i++;
			name = XString.toUpperCaseFirst(name.substring(i));
		}
		appoggio.append(name);
		name = appoggio.toString();

		if (metadata.isView()) {
			if (!name.startsWith("View")) {
				name = "View" + name;
			}
		}
		
		if (log.isDebugEnabled()) log.debug("Class name is '" + name + "'");
		return name;
	}
	
}
