package it.softecspa.database.reverser;


import it.softecspa.database.dbconnect.Version;

import java.util.ArrayList;

public class ClazzCriteria extends Clazz {

	private ClazzTable source;
	private ClazzCriteriaSkin interfaccia;

	public ClazzCriteria(ClazzTable source, ClazzCriteriaSkin interfaccia) {
		super();
		
		this.metadata = source.getMetadata();
		this.arguments = source.getArguments();
		this.source = source;
		this.interfaccia = interfaccia;
		
		this.packageName = source.getPackageName() + ".criterias";
		this.className = source.getSimpleName()+"Criteria";

		
		
		
		fieldsImport = new ArrayList<String>();
		othersImport.add(it.softecspa.database.dbconnect.ConnectionManager.class.getName());
		othersImport.add(it.softecspa.kahuna.sql.SqlWriter.class.getName());
		
		
		// IMPORT
		othersImport.add(java.sql.SQLException.class.getName());
		othersImport.add(interfaccia.getName());
		othersImport.add(source.getName());
	}
	
	

	public void write(String root) throws ReverseException {
		
		boolean rewrite = arguments.isFlush();
		
		try {
			openPrintWriter(root, rewrite);
			if (out!=null) {
				
				// Testata della classe
				printHeader();
				out.print(CR);
				
				// Fields
				printFields();
				out.print(CR);
				
				// Costruttori
				printCostructors();
				out.print(CR);
				
				// Metodi GET e SET
				printGetterSetter();
				out.print(CR);
				
				// Metodi
				printMethods();
				out.print(CR);
				
				out.print("}" + CR);		
				if (log.isDebugEnabled()) log.debug("Finished");
			}
		} catch (Exception e) {
			throw new ReverseException("Errore",e);
		} finally {
			if (out!=null) out.close();
		}
	}

	
	
	@Override
	void printHeader() {
		
		printCommonHeader();
		
		out.print("package " + packageName + ";" + CR);
		out.print(CR);
		
		printImport();
		out.print(CR);
		
		out.print("/**" + CR +
				  " * Customizable criteria filter for " + (metadata.isView()?"view":"table") +" "+ source.getTable().toUpperCase() + CR +
				  " * Class auto generated by REVERSER, version " + new Version().toString() + CR +
				  " * " + CR +
				  " * @author il Vera" + CR +
				  " */" + CR);
		out.print("public class " + className + " extends "+interfaccia.getSimpleName()+" {" + CR);
		out.print(CR);		
	}

	

	void printCostructors() {
		out.print(TB+ "public " + className + "(ConnectionManager cm) {" + CR);
		out.print(TB+TB+ "super(cm);" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
		
	}
	
	void printFields() {
		
	}
	

	void printGetterSetter() {
		
	}
	
	void printMethods() {		
				
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Customizable build select * with filter" + CR);
		out.print(TB+ " */" + CR);
		out.print(TB+ "public SqlWriter getSelect() {" + CR);
		out.print(TB+TB+ "SqlWriter sql = super.getSelect();" + CR);
		out.print(TB+TB+ "// Insert here your custom code" + CR);
		out.print(TB+TB+ "// sql.addTable(...);" + CR);
		out.print(TB+TB+ "// sql.addColumn(...);" + CR);
		out.print(TB+TB+ "// sql.addWhere(...);" + CR);
		out.print(TB+TB+ "// sql.addOption(...);" + CR);
		out.print(TB+TB+ "return sql;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);			
		
		

		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Execute select * with filter" + CR);
		out.print(TB+ " * A zero length array is returned if no record found" + CR);
		out.print(TB+ " * @throws SQLException if there is an error in your query" + CR);
		out.print(TB+ " */" + CR);
		out.print(TB+ "public " + source.getSimpleName() + "[] select() throws SQLException {" + CR);
		out.print(TB+TB+ "return " + source.getSimpleName() + ".select(this);" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
	}



	public ClazzTable getSource() {
		return source;
	}
	

}
