package it.softecspa.database.reverser;


import it.softecspa.database.dbconnect.Version;
import it.softecspa.database.reverser.util.ColumnInfo;
import it.softecspa.kahuna.lang.XString;

import java.util.ArrayList;

import org.apache.log4j.Logger;

public class ClazzCriteriaSkin extends Clazz {

	private ClazzTable source;
	

	public ClazzCriteriaSkin(ClazzTable source) {
		super();
		
		this.metadata = source.getMetadata();
		this.arguments = source.getArguments();
		this.source = source;
		
		
		this.packageName = source.getPackageName() + ".skins.criterias";
		this.className = source.getSimpleName()+"CSkin";
		
		
		fieldsImport = new ArrayList<String>();
		
		
		// IMPORT
		for (ColumnInfo column : metadata.getColumns()) {
			if (checkDRecord(column.getName()) && !column.isPrimary()) continue;
			if (checkDCancel(column.getName()) && !column.isPrimary()) continue;
			checkFieldsImport(column.getJavaType());			
		}
		
		if (fieldsImport.contains(it.softecspa.kahuna.util.calendar.EnterpriseCalendar.class.getName())) {
			othersImport.add(it.softecspa.database.dbconnect.Query.class.getName());
		}
		othersImport.add(it.softecspa.database.dbconnect.ConnectionManager.class.getName());
		othersImport.add(it.softecspa.kahuna.sql.SqlWriter.class.getName());
		
		othersImport.add(source.getName());
		othersImport.add(Logger.class.getName());
		if (metadata.getKeys().size()==1) {
			if (metadata.getKeys().get(0).isJavaTypeNumeric()) {
				// ...mi serve anche questo import
				othersImport.add(it.softecspa.database.dbconnect.DatabaseStatement.class.getName());
			}
		}
	}
	
	

	public void write(String root) throws ReverseException {
		try {
			openPrintWriter(root, true);
	
			// Testata della classe
			printHeader();
			out.print(CR);
			
			// Fields
			printFields();
			out.print(CR);
			
			// Costruttori
			printCostructors();
			out.print(CR);
			
			// Metodi GET e SET
			printGetterSetter();
			out.print(CR);
			
			// Metodi
			printMethods();
			out.print(CR);
			
			out.print("}" + CR);
		
			if (log.isDebugEnabled()) log.debug("Finished");
		} catch (Exception e) {
			throw new ReverseException("Errore",e);		
		} finally {
			if (out!=null) out.close();
		}
	}

	
	
	@Override
	void printHeader() {
		
		printCommonHeader();
		
		out.print("package " + packageName + ";" + CR);
		out.print(CR);
		
		printImport();
		out.print(CR);
		
		out.print("/**" + CR +
				  " * Abstract criteria filter for " + (metadata.isView()?"view":"table") +" "+ source.getTable().toUpperCase() + CR +
				  " * Class auto generated by REVERSER, version " + new Version().toString() + CR +
				  " * " + CR +
				  " * Warning: this class will be rewrited from REVERSER" + CR +
				  " * " + CR +
				  " * @author il Vera" + CR +
				  " */" + CR);
		out.print("public abstract class " + className + " {" + CR);
		out.print(CR);		
	}

	

	void printCostructors() {
		out.print(TB+ "protected " + className + "(ConnectionManager cm) {" + CR);
		out.print(TB+TB+ "super();" + CR);
		out.print(TB+TB+ "this.cm = cm;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
		
		
	}
	
	void printFields() {
		
		// Logger
		out.print(TB+ "protected Logger log = Logger.getLogger(getClass());" + CR);
		out.print(CR);
		
		// Connection manager
		out.print(TB+ "protected ConnectionManager cm;" + CR);
		out.print(CR);
				
		
		// Campi legati alle colonne
		for (ColumnInfo column : metadata.getColumns()) {
			if (checkDRecord(column.getName()) && !column.isPrimary()) continue;
			if (checkDCancel(column.getName())) {
				out.print(TB+ "// Flag used to extract only NOT DELETE record if is set to Boolena.TRUE" + CR);
				out.print(TB+ "protected Boolean notDeleted;" + CR);
				out.print(CR);
				if (!column.isPrimary()) continue;
			}
			
			out.print(TB+ "// " + column.getName().toUpperCase()   
					    + " - " + column.getTypeName() + (column.getPrecision()>0?"("+column.getPrecision()+(column.getScale()>0?","+column.getScale():"")+")":"") 
					    + " " + (column.isNullable()?"nullable":"NOT NULL") 
					    + (column.isPrimary()?" PK":"")
					    + (column.isAutoincrement()?" autoincrement":"")	
					  + CR);
			out.print(TB);
			if (column.isJavaTypeCalendar() && !column.isPrimary()) {
				out.print("// ");
			}
			out.print("protected " + column.getJavaType().getSimpleName() +" "+ column.getJavaFieldName() +";" + CR);
			out.print(CR);
		}
		
		out.print(TB+ "protected String custom_order_by;" + CR);
		out.print(TB+ "protected String custom_add_where;" + CR);
		out.print(TB+ "protected String custom_add_options;" + CR);
		out.print(CR);
		
		
	}
	

	void printGetterSetter() {
		for (ColumnInfo column : metadata.getColumns()) {
			if (checkDRecord(column.getName()) && !column.isPrimary()) continue;
			if (column.getName().equalsIgnoreCase(F_DELETED)) continue;
			if (checkDCancel(column.getName())) {
				out.print(TB+ "public Boolean getNotDeleted() {" + CR);
				out.print(TB+TB+ "return this.notDeleted;" + CR);
				out.print(TB+ "}" + CR);
				out.print(CR);
									
				out.print(TB+ "public void setNotDeleted(Boolean value) {" + CR);
				out.print(TB+TB+ "this.notDeleted = value;" + CR);
				out.print(TB+ "}" + CR);
				out.print(CR);
				
				if (!column.isPrimary()) continue;
			}
			
			if (!column.isJavaTypeCalendar() || column.isPrimary()) {
				String methodName = XString.toUpperCaseFirst(column.getJavaFieldName());
				String type = column.getJavaType().getSimpleName();
				
				out.print(TB+ "public "+ type + " get" + methodName + "() {" + CR);
				out.print(TB+TB+ "return this."+ column.getJavaFieldName() + ";" + CR);
				out.print(TB+ "}" + CR);
				out.print(CR);
				
				out.print(TB+ "public void set" + methodName + "(" + type + " value) {" + CR);
				out.print(TB+TB+ "this."+ column.getJavaFieldName() + " = value;" + CR);
				out.print(TB+ "}" + CR);
				out.print(CR);
				out.print(CR);
			}
		}
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * ORDER BY condition" + CR);
		out.print(TB+ " */" + CR);		
		out.print(TB+ "public void orderBy(String value) {" + CR);
		out.print(TB+TB+ "this.custom_order_by = value;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Custom WHERE condition to add in query composition" + CR);
		out.print(TB+ " */" + CR);		
		out.print(TB+ "public void addCustomWhere(String value) {" + CR);
		out.print(TB+TB+ "this.custom_add_where = value;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Custom option to add in query composition" + CR);
		out.print(TB+ " */" + CR);		
		out.print(TB+ "public void addCustomOptions(String value) {" + CR);
		out.print(TB+TB+ "this.custom_add_options = value;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
		out.print(CR);
	}
	
	void printMethods() {		
		
		out.print(TB+ "public ConnectionManager getConnectionManager() {" + CR);
		out.print(TB+TB+ "return this.cm;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Columns used in select with alias" + CR);
		out.print(TB+ " */" + CR);
		out.print(TB+ "protected String getColumns(String alias) {" + CR);
		
		for (int i=0; i<metadata.getColumns().size(); ) {
			ColumnInfo column = metadata.getColumns().get(i);
			out.print(TB+TB+ (i==0?"return ":"  \", \"+") + "alias+\"." + column.getName() +"\"");
			i++;
			out.print((i==metadata.getColumns().size()?";":" +") + CR);			
		}
		//out.print(TB+TB+ "return \""+ colonne +"\";" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);	
		
		
		
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Build select * using alias" + CR);
		out.print(TB+ " */" + CR);
		out.print(TB+ "protected SqlWriter getSelectAll(String alias) {" + CR);
		out.print(TB+TB+ "SqlWriter sql = new SqlWriter();" + CR);
		out.print(TB+TB+ "sql.setColumns(getColumns(alias));" + CR);
		out.print(TB+TB+ "sql.setTables("+source.getSimpleName()+".NAME +\" \"+ alias);" + CR);
		out.print(TB+TB+ "return sql;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);	
		
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Build select * with filter with standard alias 't'" + CR);
		out.print(TB+ " */" + CR);
		out.print(TB+ "protected SqlWriter getSelect() {" + CR);
		out.print(TB+TB+ "return getSelect(\"t\");" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);	
		
		
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Build select * with filter using custom alias" + CR);
		out.print(TB+ " */" + CR);
		out.print(TB+ "protected SqlWriter getSelect(String alias) {" + CR);
		out.print(TB+TB+ "SqlWriter sql = getSelectAll(alias);" + CR);
		for (ColumnInfo column : metadata.getColumns()) {			
			if (checkDRecord(column.getName())) continue;
			if (checkDCancel(column.getName())) {
				out.print(TB+TB+ "// Check delete or not if value is not null" + CR);
				out.print(TB+TB+ "if (this.notDeleted != null)\t\t\t sql.addWhere(alias+\".d_cancel \" + (this.notDeleted.booleanValue()?\"is\":\"is not\") + \" null\");" + CR);
				continue;
			}			
			/*
			 * Fix, nelle select volutamente la condizione di ricerca per le date  esclusa
			 */
			if (column.isJavaTypeCalendar() && !column.isPrimary()) {
				out.print(TB+TB+ "// No query condition set for column " + column.getName().toUpperCase() + CR);
			} else {
				out.print(TB+TB+ "if (this."+column.getJavaFieldName()+" != null)\t\t\t sql.addWhere(alias+\"."+column.getName()+" = \""+sqlTypeCast("+ ",column.getJavaType(), column.getJavaFieldName(), false)+");" + CR);
			}
		}
		out.print(CR);
		out.print(TB+TB+ "// Custom WHERE" + CR);
		out.print(TB+TB+ "if (this.custom_add_where!=null) sql.addWhere(this.custom_add_where);" + CR);
		out.print(TB+TB+ "// Custom OPTIONS" + CR);
		out.print(TB+TB+ "if (this.custom_add_options!=null) sql.addOption(this.custom_add_options);" + CR);
		out.print(TB+TB+ "// Custom ORDER_BY" + CR);
		out.print(TB+TB+ "if (this.custom_order_by!=null) sql.addOption(\"ORDER BY \"+this.custom_order_by);" + CR);
		out.print(CR);
		out.print(TB+TB+ "return sql;" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);			
		
		
		if (metadata.getKeys().size()==1) {
			if (metadata.getKeys().get(0).isJavaTypeNumeric()) {
				
				// Ho bisogno di una funzione per calcolare il max progressivo
				ColumnInfo column = metadata.getKeys().get(0);
				
				out.print(TB+ "/**" + CR);
				out.print(TB+ " * Build select MAX for recover id" + CR);
				out.print(TB+ " */" + CR);
				out.print(TB+ "public static "+column.getJavaType().getSimpleName()+" getMaxId(DatabaseStatement dbs) throws java.sql.SQLException {" + CR);
				out.print(TB+TB+ "SqlWriter sql = new SqlWriter();" + CR);
				out.print(TB+TB+ "sql.setColumns(\"MAX("+ column.getName() +")\");" + CR);
				out.print(TB+TB+ "sql.setTables("+source.getSimpleName()+".NAME);" + CR);
				out.print(TB+TB+ "return new "+column.getJavaType().getSimpleName()+"(dbs.getInt(sql.costruisciSelect()));" + CR);
				out.print(TB+ "}" + CR);
				out.print(CR);					
			}
		}
		
	}



	

}
