package it.softecspa.database.reverser;

import it.softecspa.database.dbconnect.Version;
import it.softecspa.database.reverser.util.ColumnInfo;
import it.softecspa.database.reverser.util.TableInfo;
import it.softecspa.kahuna.lang.XString;

import java.util.ArrayList;

public class ClazzTable extends Clazz {

	
	private ClazzCriteria criteria;
	private ClazzCriteriaSkin interfaccia_criteria;
	private ClazzTableSkin interfaccia;
	
	private String table;	

		
	public ClazzTable(Arguments arguments, String tableName, TableInfo metadata) {
		super();
		
		this.arguments = arguments;
		this.metadata = metadata;
		
		this.packageName = arguments.getStorePackage();
		this.className = createClassName(tableName);
		this.table = tableName;
		
		// TODO gestire i tipi primitivi se il campo  NOT NULL
		
		fieldsImport = new ArrayList<String>();
		
		// IMPORT
		for (ColumnInfo column : metadata.getColumns()) {
			String name = createFieldName(column.getName());
			column.setJavaFieldName(name);
			Class<?> type = new CustomClassType().customType(column.getTypeName(), column.getJavaType());
			column.setJavaType(type);	
			
			if (column.isPrimary()) checkFieldsImport(type);
		}
		
		othersImport.add(java.sql.SQLException.class.getName());
		if (!metadata.isView()) {
			othersImport.add(it.softecspa.database.dbconnect.ConnectionManager.class.getName());
			othersImport.add(it.softecspa.database.dbconnect.DatabaseStatement.class.getName());
			othersImport.add(it.softecspa.database.dbconnect.NoRecordFoundException.class.getName());						
		}
		othersImport.add(it.softecspa.kahuna.sql.SqlWriter.class.getName());
		
		
		// Creazione interfaccia per iu criteria
		interfaccia_criteria = new ClazzCriteriaSkin(this);	
		
		// Creazione del Criteria filter
		criteria = new ClazzCriteria(this,interfaccia_criteria);
		othersImport.add(criteria.getName());
		
		
		// Creazione della interfaccia
		interfaccia = new ClazzTableSkin(this);		
		
			
	}
	

	

	private String createFieldName(String name) {
		
		name = XString.replaceAll(name, "_", " ");
		name = XString.replaceAll(name, "-", " ");
		name = XString.replaceAll(name, ".", " ");
		name = name.trim();

		
		// Maiuscolo dopo lo spazio/underscore
		int i = 0;
		String appoggio = "";
		
		int conta = 0;
		while ((i = name.indexOf(" ")) >= 0) {
			conta++;
			String frame = name.substring(0, i);
			
			boolean jump = false;
			if (arguments.isBlockAloneChar()) {
				/*
				 * Salto l'eventuale primo carattere utilizzato 
				 * per lasciare capire il tipo di dato
				 */
				if (conta==1 && frame.length()<=1) {
					jump = true;
				}	
			}
			if (!jump) {				
				appoggio += frame;	
			}
			i++;
			name = XString.toUpperCaseFirst(name.substring(i));
		}
		appoggio += name;
		name = XString.toLowerCaseFirst(appoggio.toString());

		if (log.isDebugEnabled()) log.debug("Field name is '" + name + "'");
		return name;
	}

	
	
	
	public void write(String root) throws ReverseException {
		
		boolean rewrite = arguments.isFlush();
		
		try {
			openPrintWriter(root, rewrite);
			if (out!=null) {
			
				// Testata della classe
				printHeader();
				//out.print(CR);			
				
				// Fields
				printFields();
				//out.print(CR);
				
				// Costruttori
				printCostructors();
				//out.print(CR);
				
				// Metodi GET e SET
				printGetterSetter();
				//out.print(CR);
				
				// Metodi
				printMethods();
				//out.print(CR);
				
				out.print("}" + CR);		
				if (log.isDebugEnabled()) log.debug("Finished");
			}
		} catch (Exception e) {
			throw new ReverseException("Errore",e);
		} finally {
			if (out!=null) out.close();
		}
		
		log.info("Create abstract class");
		interfaccia.write(root);
		
		log.info("Create filter class");
		criteria.write(root);
		
		log.info("Create abstract filter class");
		interfaccia_criteria.write(root);
		
		
	}

	
	
	
	
	
			
	@Override
	void printHeader() {
		
		out.print("package " + packageName + ";" + CR);
		printCommonHeader();
		printImport();
		
		out.print("/**" + CR +
				  " * Customizable manager for " + (metadata.isView()?"view":"table") +" "+ getTable().toUpperCase() + CR +
				  " * Class auto generated by REVERSER, version " + new Version().toString() + CR +
				  " * " + CR +
				  " * @author il Vera" + CR +
				  " */" + CR);
		out.print("public class " + className + " extends "+interfaccia.getName()+" {" + CR);
		out.print(CR);
	}
	

	void printCostructors() {
		out.print(TB+ "public " + className + "() {" + CR);
		out.print(TB+TB+ "super();" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);		
		
		
		// Costruttore per estrazione record per chiave
		if (metadata.getKeys().size()>0) {
			String param = "";
			String names = "";
			for (ColumnInfo column : metadata.getKeys()) {
				if (!"".equals(param)) param += ", ";
				param += column.getJavaType().getSimpleName() +" "+ column.getJavaFieldName();
				
				if (!"".equals(names)) names += ", ";
				names += column.getJavaFieldName();
			}			
			
			out.print(TB+ "/**" + CR);
			out.print(TB+ " * Extract bean using key" + CR);
			out.print(TB+ " */" + CR);
			out.print(TB+ "public " + className + "(ConnectionManager cm, "+param+") throws NoRecordFoundException, SQLException {" + CR);
			out.print(TB+TB+ "super(cm, "+names+");" + CR);
			out.print(TB+ "}" + CR);
			out.print(CR);		
		}
	}

	

	void printFields() {
		
	}

	void printGetterSetter() {
		
	}

	
	@Override
	void printMethods() {
		out.print(TB+ "/**" + CR);
		out.print(TB+ " * Execute select * with criteria" + CR);
		out.print(TB+ " * @throws SQLException if there is an error in your query" + CR);
		out.print(TB+ " */" + CR);
		out.print(TB+ "public static " + className + "[] select(" + criteria.getSimpleName() + " criteria) throws SQLException {" + CR);
		out.print(TB+TB+ "SqlWriter sql = criteria.getSelect();" + CR);
		out.print(TB+TB+ "return (" + className + "[])(new " + className + "()).getRows(criteria.getConnectionManager(), sql.costruisciSelect());" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
		
		
		if (metadata.isView()) {
			// Nessun metodo
			
		} else {
			out.print(TB+ "/**" + CR);
			out.print(TB+ " * Customizable update method" + CR);
			out.print(TB+ " * @param updateType operation to execute" + CR);
			out.print(TB+ " * @param dbs DatabaseStatement that perform operation" + CR);
			out.print(TB+ " * @return number of update rows or new autoincrement id" + CR);
			out.print(TB+ " * @throws SQLException if there is an error in your query" + CR);
			out.print(TB+ " */" + CR);	
			out.print(TB+"@Override" + CR);
			out.print(TB+ "public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {" + CR);
			out.print(TB+TB+ "// Insert here your custom code" + CR);		
			out.print(TB+TB+ "return super.updateRecord(updateType, dbs);" + CR);
			out.print(TB+ "}" + CR);
			out.print(TB+ CR);
		}
		
		
		if (arguments.isCloneable()) {
			/*
			 * http://www.cosenonjaviste.it/linterfaccia-java-cloneable/
			 * 
			 * In pratica limplementazione corretta deve, dopo aver invocato super.clone(), 
			 * clonare tutti i campi non primitivi e non immutabili per evitare condivisioni di memoria.
			 * 
			 * Ad esempio l'oggetto Calendar e le sue estenzioni
			 */
			out.print(TB+"@Override" + CR);
			out.print(TB+"public " + className + " clone() {" + CR);
			out.print(TB+TB+"try {" + CR);
			out.print(TB+TB+TB+className+" c = ("+className+") super.clone();" + CR);
			//
			out.print(TB+TB+TB+"// Insert custom clonable objects" + CR);
			//
			out.print(TB+TB+TB+"return c;" + CR);
			out.print(TB+TB+"} catch (CloneNotSupportedException e) {" + CR);
			out.print(TB+TB+TB+"throw new RuntimeException(e);" + CR);
			out.print(TB+TB+"}" + CR);
			out.print(TB+"}" + CR);
			out.print(CR);
		}
		
	}


	public String getTable() {
		return table;
	}

	
	
	public ClazzCriteria getCriteria() {
		return criteria;
	}

	public ClazzTableSkin getInterface() {
		return interfaccia;
	}


	

}
