package it.softecspa.database.reverser;

import it.softecspa.database.dbconnect.Version;
import it.softecspa.database.reverser.util.ColumnInfo;
import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.util.ArrayList;

import org.apache.log4j.Logger;

public class ClazzTableSkin extends Clazz {

	private ClazzTable source;
	private boolean autoincrement;
	private boolean cancellable;
		
	public ClazzTableSkin(ClazzTable source) {
		super();
		
		this.arguments = source.getArguments();
		this.metadata = source.getMetadata();
		this.source = source;
		
		
		this.packageName = source.getPackageName() + ".skins";
		this.className = source.getSimpleName()+"Skin";
		
		fieldsImport = new ArrayList<String>();		
		
		// IMPORT e...
		for (ColumnInfo column : metadata.getColumns()) {
			checkFieldsImport(column.getJavaType());	
			// ...pu essere utilizzata la d_cancel
			if (checkDCancel(column.getName())) {
				cancellable = true;
			}
		}
		
		othersImport.add(Logger.class.getName());
		othersImport.add(java.sql.ResultSet.class.getName());
		othersImport.add(java.sql.SQLException.class.getName());
		
		othersImport.add(it.softecspa.database.dbconnect.UpdatableRow.class.getName());
		if (!metadata.isView()) {
			if (fieldsImport.contains(it.softecspa.kahuna.util.calendar.EnterpriseCalendar.class.getName())) { 
				othersImport.add(it.softecspa.database.dbconnect.Query.class.getName());
			}
			othersImport.add(it.softecspa.database.dbconnect.ConnectionManager.class.getName());
			othersImport.add(it.softecspa.database.dbconnect.NoRecordFoundException.class.getName());						
		}
		othersImport.add(it.softecspa.database.dbconnect.DatabaseStatement.class.getName());
		othersImport.add(it.softecspa.kahuna.sql.SqlWriter.class.getName());
		
		if (metadata.getKeys().size()>0) {		
			othersImport.add(source.getCriteria().getName());		
		}
		
		
		
		/* Cerco di capire se la tabella possiede una chiave con indice AUTOINCREMENT
		 * - Chiave di 1 campo
		 * - Campo numerico
		autoincrement = (metadata.getKeys().size()==1 && 
				 		 metadata.getKeys().get(0).isJavaTypeNumeric());
		*/
		
		autoincrement = (metadata.getKeys().size()==1 && 
		 		 		 metadata.getKeys().get(0).isAutoincrement());
	}
	
	
	
	
	
	public void write(String root) throws ReverseException {
		
		try {
			openPrintWriter(root, true);
			
			// Testata della classe
			printHeader();
			out.print(CR);			
			
			// Fields
			printFields();
			out.print(CR);
			
			// Costruttori
			printCostructors();
			out.print(CR);
			
			// Metodi GET e SET
			printGetterSetter();
			out.print(CR);
			
			// Metodi
			printMethods();
			out.print(CR);
			
			// Costruzione INSERT/UPDATE/DELETE standard
			printUpdate();
			out.print(CR);
			
			out.print("}" + CR);
		
			if (log.isDebugEnabled()) log.debug("Finished");
		} catch (Exception e) {
			throw new ReverseException("Errore",e);
		} finally {
			if (out!=null) out.close();
		}
		
		
		
		
		
	}

	
	private String createAlias(String alias) {
		if (arguments.getTablePrefix() > 0) {
			int l = (arguments.getTablePrefix()<1?1:arguments.getTablePrefix());
			alias = alias.substring(0,l);
		}
		
		alias = XString.replaceAll(alias, "_", "");
		alias = XString.replaceAll(alias, "-", "");
		alias = XString.replaceAll(alias, ".", "");
		alias = alias.trim();

		alias = alias.toLowerCase();
		
		if (log.isDebugEnabled()) log.debug("Table alias is '" + alias + "'");
		return alias;
	}

	
	void printFields() {
		
		// Nome della tabella
		out.print(TB+ "// "+(metadata.isView()?"View":"Table")+ " name: " + source.getTable().toUpperCase() +"" + CR);
		out.print(TB+ "public static final String NAME = \"" + source.getTable() +"\";" + CR);
		out.print(CR);
		out.print(TB+ "public static final String ALIAS = \"" + createAlias(source.getTable()) +"\";" + CR);
		out.print(CR);
		out.print(CR);
		
		// Logger
		out.print(TB+ "protected Logger log = Logger.getLogger("+className+".class);" + CR);
		if (autoincrement) {
			/* Flag utilizzato per impostare in automatico
			 * il calcolo del massimo indice nelle insert calcola
			 * default = FALSE
			 * ...funziona in logica negata
			 */
			out.print(TB+ "protected boolean lockAutoincrementRetrieves;" + CR);
		}
		out.print(CR);
		
		// Campi legati alle colonne
		for (ColumnInfo column : metadata.getColumns()) {
			out.print(TB+ "// " + column.getName().toUpperCase()   
					    + " - " + column.getTypeName() + (column.getPrecision()>0?"("+column.getPrecision()+(column.getScale()>0?","+column.getScale():"")+")":"") 
					    + " " + (column.isNullable()?"nullable":"NOT NULL")
					    + (column.isPrimary()?" PK":"")
					    + (column.isAutoincrement()?" autoincrement":"")					    
					  + CR);
			out.print(TB+ "protected " + column.getJavaType().getSimpleName() +" "+ column.getJavaFieldName() +";" + CR);
			
			if (checkDRecord(column.getName())) {
				out.print(TB+ "protected " + column.getJavaType().getSimpleName() +" old_d_record;" + CR);
			}
			out.print(CR);
		}
		
	}

	void printGetterSetter() {
		for (ColumnInfo column : metadata.getColumns()) {
			
			String methodName = XString.toUpperCaseFirst(column.getJavaFieldName());
			String type = column.getJavaType().getSimpleName();
			
			// GETTER
			out.print(TB+ "public "+ type + " get" + methodName + "() {" + CR);
			out.print(TB+TB+ "return this."+ column.getJavaFieldName() + ";" + CR);
			out.print(TB+ "}" + CR);
			out.print(CR);
			
			// SETTER
			out.print(TB+ "public void set" + methodName + "(" + type + " value) {" + CR);
			out.print(TB+TB+ "this."+ column.getJavaFieldName() + " = value;" + CR);
			out.print(TB+ "}" + CR);
			out.print(CR);
			
			//out.print(CR);
		}
		
	}
	
	
	private void printUpdate() {
			
		final String DBMS_TIMESTAMP = "Query.toSQL(Query.getFunCurrentDateTime(dbs.getDBMS()))";
		
		
		if (metadata.isView()) {
			out.print(TB+ "/**" + CR);
			out.print(TB+ " * Empty implementation of update method, this is a VIEW" + CR);
			out.print(TB+ " */" + CR);		
			out.print(TB+ "public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {" + CR);
			
		} else {
			
			String autoincrement_name = null;
			
			
			out.print(TB+ "/**" + CR);
			out.print(TB+ " * Standard implementation of update method" + CR);
			out.print(TB+ " * @param updateType operation to execute" + CR);
			out.print(TB+ " * @param dbs DatabaseStatement that perform operation" + CR);
			out.print(TB+ " * @return number of update rows or new autoincrement id" + CR);
			out.print(TB+ " * @throws SQLException if there is an error in your query" + CR);
			out.print(TB+ " */" + CR);		
			out.print(TB+ "public int updateRecord(UpdateType updateType, DatabaseStatement dbs) throws SQLException {" + CR);
			out.print(TB+TB+ "SqlWriter sql = new SqlWriter();" + CR);
			out.print(TB+TB+ "sql.setTables(NAME);" + CR);
			
			// INSERT
			out.print(TB+TB+ "if (updateType == INSERT) {" + CR);
			for (ColumnInfo column : metadata.getColumns()) {
				if (column.isPrimary() && autoincrement) {
					out.print(TB+TB+TB+ "sql.addValue(\"" +column.getName()+ "\"\t\t\t, " + sqlTypeCast("",column.getJavaType(), column.getJavaFieldName(), true)+");" + CR);
					autoincrement_name = column.getJavaFieldName();
					continue;
				}
				if (checkDRecord(column.getName())) {
					// Se D_RECORD  nulla inserisco il TIMESTAMP
					out.print(TB+TB+TB+ "sql.addValue(\"" +column.getName()+ "\"\t\t\t, (this."+column.getJavaFieldName()+"==null?"+DBMS_TIMESTAMP+":"+sqlTypeCast("",column.getJavaType(), column.getJavaFieldName(), true)+"));" + CR);
					continue;
				}
				if (column.getName().equalsIgnoreCase(F_DELETED)) {					
					// F_DELETED
					out.print(TB+TB+TB+ "if (this."+column.getJavaFieldName()+"!=null) sql.addValue(\"" +column.getName()+ "\"\t\t\t, " + sqlTypeCast("",column.getJavaType(), column.getJavaFieldName(), true)+");" + CR);
					continue;
				}
				out.print(TB+TB+TB+ "sql.addValue(\"" +column.getName()+ "\"\t\t\t, " + sqlTypeCast("",column.getJavaType(), column.getJavaFieldName(), true)+");" + CR);
			}
			
			out.print(TB+TB+TB+ "int _retval = dbs.execute(sql.costruisciInsert());" + CR);	
			if (autoincrement) {	
				out.print(TB+TB+TB+ "if (lockAutoincrementRetrieves) return _retval;" + CR);
				out.print(CR);
				out.print(TB+TB+TB+ "// Calcolo del massimo progressivo e lo assegno alla chiave" + CR);	
				out.print(TB+TB+TB+ "this." + autoincrement_name + " = "+source.getCriteria().getSimpleName()+".getMaxId(dbs);" + CR);	
				out.print(TB+TB+TB+ "return this." + autoincrement_name + ".intValue();" + CR);
			} else {
				out.print(TB+TB+TB+ "return _retval;" + CR);	
			}
			out.print(CR);	
				
			// UPDATE
			out.print(TB+TB+ "} else if (updateType == UPDATE) {" + CR);
			for (ColumnInfo column : metadata.getColumns()) {
				if (!column.isPrimary()) {
					if (checkDRecord(column.getName())) {
						// Se D_RECORD non  cambiata o  nulla inserisco il TIMESTAMP
						//out.print(TB+TB+TB+ "sql.addColumnSET(\"" +column.getName()+ "\"\t\t\t, "+DBMS_TIMESTAMP+");" + CR);
						out.print(TB+TB+TB+ "sql.addColumnSET(\"" +column.getName()+ "\"\t\t\t, (this."+column.getJavaFieldName()+"==null || this."+column.getJavaFieldName()+".equals(this.old_d_record)?"+DBMS_TIMESTAMP+":"+sqlTypeCast("",column.getJavaType(), column.getJavaFieldName(), true)+"));" + CR);
						continue;
					}
					out.print(TB+TB+TB+ "sql.addColumnSET(\"" +column.getName()+ "\"\t\t\t, " + sqlTypeCast("",column.getJavaType(), column.getJavaFieldName(), true)+");" + CR);
				}
			}
			for (ColumnInfo column : metadata.getKeys()) {
				out.print(TB+TB+TB+ "sql.addWhere(\"" +column.getName()+ " = \"" + sqlTypeCast(" +",column.getJavaType(), column.getJavaFieldName(), true)+");" + CR);	
			}
			out.print(TB+TB+TB+ "return dbs.execute(sql.costruisciUpdate());" + CR);	
			out.print(CR);
			
			// DELETE
			out.print(TB+TB+ "} else if (updateType == DELETE) {" + CR);
			if (arguments.isDeleteWithCancel() && cancellable) {
				// f_deleted
				for (ColumnInfo column : metadata.getColumns()) {
					if (column.getName().equalsIgnoreCase(F_DELETED)) {
						out.print(TB+TB+TB+ "sql.addColumnSET(\"f_deleted\"\t\t\t, \"1\");" + CR);
						break;
					}
				}
				// d_cancel				
				out.print(TB+TB+TB+ "sql.addColumnSET(\"d_cancel\"\t\t\t, "+DBMS_TIMESTAMP+");" + CR);
				// d_record
				for (ColumnInfo column : metadata.getColumns()) {
					if (checkDRecord(column.getName())) {
						// Se D_RECORD non  cambiata o  nulla inserisco il TIMESTAMP
						//out.print(TB+TB+TB+ "sql.addColumnSET(\"" +column.getName()+ "\"\t\t\t, "+DBMS_TIMESTAMP+");" + CR);
						out.print(TB+TB+TB+ "sql.addColumnSET(\"" +column.getName()+ "\"\t\t\t, (this."+column.getJavaFieldName()+"==null || this."+column.getJavaFieldName()+".equals(this.old_d_record)?"+DBMS_TIMESTAMP+":"+sqlTypeCast("",column.getJavaType(), column.getJavaFieldName(), true)+"));" + CR);
						break;
					}
				}
				for (ColumnInfo column : metadata.getKeys()) {
					out.print(TB+TB+TB+ "sql.addWhere(\"" +column.getName()+ " = \"" + sqlTypeCast(" +",column.getJavaType(), column.getJavaFieldName(), true)+");" + CR);	
				}
				out.print(TB+TB+TB+ "return dbs.execute(sql.costruisciUpdate());" + CR);	
			} else {
				for (ColumnInfo column : metadata.getKeys()) {
					out.print(TB+TB+TB+ "sql.addWhere(\"" +column.getName()+ " = \"" + sqlTypeCast(" +",column.getJavaType(), column.getJavaFieldName(), true)+");" + CR);	
				}
				out.print(TB+TB+TB+ "return dbs.execute(sql.costruisciDelete());" + CR);			
			}
			out.print(TB+TB+ "}" + CR);
				
		}
		
		
		
		out.print(TB+TB+ "return 0;" + CR);
		out.print(TB+ "}" + CR);
		out.print(TB+ CR);
		
		boolean separator = true;
		out.print(TB+ "protected void readRow(ResultSet rs) throws SQLException {" + CR);
		// Lettura del resulset per caricare la struttura
		for (ColumnInfo column : metadata.getColumns()) {
			if (separator && !column.isPrimary()) {
				separator = false;
				out.print(TB+TB+ "// -------" + CR);
			}
			String methodName = XString.toUpperCaseFirst(column.getJavaFieldName());
			out.print(TB+TB+ "set"+methodName +"("+ resultsetGetCast("rs",column.getJavaType(), column.getName()) +");" + CR);
			if (checkDRecord(column.getName())) {
				out.print(TB+TB+ "this.old_d_record = get"+methodName +"(); // Cache della colonna D_RECORD" + CR);
			}
		}		
		out.print(TB+ "}" + CR);
		
	}

	
	

	
	
	

	void printCostructors() {
		out.print(TB+ "protected " + className + "() {" + CR);
		out.print(TB+TB+ "super();" + CR);
		out.print(TB+ "}" + CR);
		out.print(CR);
				
		
		
		if (metadata.getKeys().size()>0) {
			String param = "";
			for (ColumnInfo column : metadata.getKeys()) {
				if (!"".equals(param)) param += ", ";
				param += column.getJavaType().getSimpleName() +" "+ column.getJavaFieldName();			
			}			
			
			out.print(TB+ "/**" + CR);
			out.print(TB+ " * Extract bean using key" + CR);
			out.print(TB+ " */" + CR);
			out.print(TB+ "protected " + className + "(ConnectionManager cm, "+param+") throws NoRecordFoundException, SQLException {" + CR);
			out.print(TB+TB+ "this();" + CR);
			out.print(TB+TB + "// Setup key filter values" + CR);
			out.print(TB+TB+ source.getCriteria().getSimpleName() +" filter = new " + source.getCriteria().getSimpleName() + "(cm);" + CR);
			for (ColumnInfo column : metadata.getKeys()) {
				String methodName = XString.toUpperCaseFirst(column.getJavaFieldName());
				if (column.isJavaTypeCalendar() && !column.isPrimary()) {
					out.print("// ");
				}
				out.print(TB+TB+ "filter.set" +methodName + "("+column.getJavaFieldName()+");" + CR);
			}
			out.print(TB+TB+ "readRow(cm, filter.getSelect().costruisciSelect());" + CR);		
			out.print(TB+ "}" + CR);
			out.print(CR);
		}
		
	}

	

	@Override
	void printHeader() {
		
		out.print("package " + packageName + ";" + CR);
		printCommonHeader();
		printImport();
		
		out.print("/**" + CR +
				  " * Abstract manager for " + (metadata.isView()?"view":"table") +" "+ source.getTable().toUpperCase() + CR +
				  " * Class auto generated by REVERSER, version " + new Version().toString() + CR +
				  " * " + CR +
				  " * Warning: this class will be rewrited from REVERSER" + CR +
				  " * " + CR +
				  " * @author il Vera" + CR +
				  " */" + CR);
		out.print("public abstract class " + className + " extends UpdatableRow "+(arguments.isCloneable()?"implements Cloneable ":"")+"{" + CR);
		out.print(CR);
	}


	@Override
	void printMethods() {
		if (arguments.isCloneable()) {
			/*
			 * http://www.cosenonjaviste.it/linterfaccia-java-cloneable/
			 * 
			 * In pratica limplementazione corretta deve, dopo aver invocato super.clone(), 
			 * clonare tutti i campi non primitivi e non immutabili per evitare condivisioni di memoria.
			 * 
			 * Ad esempio l'oggetto Calendar e le sue estenzioni
			 */
			out.print(TB+"@Override" + CR);
			out.print(TB+"public " + className + " clone() throws CloneNotSupportedException {" + CR);
			out.print(TB+TB+className+" c = ("+className+") super.clone();" + CR);
			//			
			out.print(TB+TB+"//" + CR);
			out.print(TB+TB+"// Not primitive or not immutable objects" + CR);
			for (ColumnInfo column : metadata.getColumns()) {		
				// ...aggiungo tutti gli oggetti Calendar* perch non immutabili
				if (column.getJavaType()==EnterpriseCalendar.class) {
					out.print(TB+TB+"if (this."+column.getJavaFieldName()+"!=null) c."+column.getJavaFieldName()+" = ("+column.getJavaType().getSimpleName()+") this."+column.getJavaFieldName()+".clone();" + CR);
					if (checkDRecord(column.getName())) {
						out.print(TB+TB+"if (this.old_d_record!=null) c.old_d_record = ("+column.getJavaType().getSimpleName()+") this.old_d_record.clone();" + CR);
					}
				}
			}
			out.print(TB+TB+"//" + CR);
			//			
			out.print(TB+TB+"return c;" + CR);
			out.print(TB+"}" + CR);
			out.print(CR);
		}
		
		
	}


	

}
