package it.softecspa.database.reverser;

import it.softecspa.database.reverser.util.TableInfo;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;


public class DatabaseManager {

	public class TableBean {		
		String name;
		String type;		
	}
	
	
	
	Logger log = Logger.getLogger(getClass());
	
	private Connection connection;
	private DatabaseMetaData databaseMetaData;
	
	private List<TableBean> tables; 
	
	
	
	public DatabaseManager(String dbDriver, String dbServer, String dbUser, String dbPassword) throws ReverseException {
		
		try {
			Class.forName(dbDriver);
		} catch (ClassNotFoundException e) {
			throw new ReverseException("Driver not found: "+dbDriver);
		}
		try {
			connection = DriverManager.getConnection(dbServer, dbUser, dbPassword);
			if (log.isDebugEnabled()) log.debug("Connection with database established");
		} catch (SQLException e) {
			throw new ReverseException("Error open connection, check user, password or database value");
		}
		       		   
	}
	
	public List<TableBean> getTables() throws ReverseException {
		if (tables!=null) return tables;
		
		
		try {
			databaseMetaData  = connection.getMetaData();
		} catch (SQLException e) {
			throw new ReverseException("SQL error extracting metadata info",e);
		}
		
		tables = new ArrayList<TableBean>();
		log.info("Extracting tables list");
		ResultSet res = null;
		try {
			res = databaseMetaData.getTables(connection.getCatalog(), "%", "%", null);
			while (res.next()) {
				TableBean bean = new TableBean();
				bean.name = res.getString("TABLE_NAME");
				bean.type = res.getString("TABLE_TYPE");
				tables.add(bean);
			}			
		} catch (SQLException e) {
			throw new ReverseException("SQL error extracting table",e);
		} finally {	
			try {
				if (res!=null) res.close();
			} catch (SQLException e) {
				log.warn(e.toString(), e);
			}
		}		
				
		log.info("Database composed by "+tables.size()+" tables");
		return tables;
	}

	
	
	public TableInfo getMetadata(String tableName, boolean view) throws ReverseException {		
		log.info("Extracting tables info for " + (view?"VIEW":"TABLE") +" "+ tableName);
		try {
			TableInfo info = new TableInfo(connection, tableName, view);
			return info;
		} catch (SQLException e) {
			throw new ReverseException("SQL error extracting table info",e);
		}
		
		/*
		String query = "select * from "+tableName;
		if (SqlDB.isMySQL(connection)) {
			query += " limit 1";
		} else if (SqlDB.isOracle(connection)) {
			query += " where ROWNUM<1";
		} else {
			throw new ReverseException("Database not supported");
		}	
		
		
		Sql sql = null;
		try {
			sql = new Sql(connection);
			ResultSet res = sql.executeSelect(query);
			return new KMetadata(res);			
		} catch (SQLException e) {
			throw new ReverseException("SQL error extracting table",e);
		} finally {			
			try {
				if (sql!=null) sql.close();
			} catch (SQLException e) {
				log.warn(e.toString(), e);
			}
		}
		*/
		
		
	}
	
	//http://www.devx.com/dbzone/Article/27992/1954


}
