package it.softecspa.database.reverser;

import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;


public class Log4Configurator {

	final static String xml = 	"<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
						//"<!DOCTYPE log4j:configuration SYSTEM \"log4j.dtd\">" +
						"<log4j:configuration debug=\"false\" xmlns:log4j=\"http://jakarta.apache.org/log4j/\">" +
						
							"<!-- CONSOLE -->" +
							"<appender name=\"console\" class=\"org.apache.log4j.ConsoleAppender\">" +
								"<layout class=\"org.apache.log4j.PatternLayout\">" +
									"<param name=\"ConversionPattern\" value=\"[%-5p] - %m%n\" />" +
								"</layout>" +
							"</appender>" +
						
							"<!-- CATEGORY -->" +
							"<category name=\"it.softecspa.database.dbconnect\" additivity=\"false\">" +
						    	"<priority value=\"INFO\" />" +
						    	"<appender-ref ref=\"console\" />" +
						    "</category>" +
							
						    "<!-- " +
							"<category name=\"it.softecspa.database.dbconnect.SQL\" additivity=\"false\">" +
						    	"<priority value=\"TRACE\" />" +
						    	"<appender-ref ref=\"console\" />" +
						    "</category>" +
						    " -->" +
						    
						    "<!-- " +
						    "<category name=\"it.softecspa.kahuna.SQL\" additivity=\"false\">" +
					    		"<priority value=\"TRACE\" />" +
					    		"<appender-ref ref=\"console\" />" +
					    	"</category>" +
					    	" -->" +	
					    	
						    "<!-- ROOT -->" +
							"<root>" +
								"<priority value=\"INFO\"/>" +       
						        "<appender-ref ref=\"console\"/>" +
						    "</root>" +
						"</log4j:configuration>";
	
	
	public static void configure() throws ReverseException {
		configure(xml);
	}
	
	public static void configure(String xml) throws ReverseException {
		Document document = null;
		
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			InputSource is = new InputSource();
			is.setCharacterStream(new StringReader(xml));
			document = (Document) db.parse(is);
			/*			
			InputSource is = new InputSource();
		    is.setCharacterStream(new StringReader(xml));
		    document = (Document) builder.build(is);
			*/
		} catch (IOException e) {
			e.printStackTrace();
			throw new ReverseException("Error reading log4j.xml",e);		
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
			throw new ReverseException("Error reading log4j.xml",e);
		} catch (SAXException e) {
			e.printStackTrace();
			throw new ReverseException("Error reading log4j.xml",e);
		}
		
		DOMConfigurator.configure(document.getDocumentElement());		
	}
	
}
