package it.softecspa.database.reverser;

import it.softecspa.database.reverser.DatabaseManager.TableBean;
import it.softecspa.database.reverser.util.TableInfo;
import it.softecspa.kahuna.io.File;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

public class Reverser  {
	
	private static Logger log = Logger.getLogger(Reverser.class);
	
	
	private Arguments arguments;
	private DatabaseManager manager;

	
	private List<String> tables;
	private List<String> classes;
	private java.io.File path;
	
	
	public Reverser(Arguments arguments) {		
		this.arguments = arguments;
	}

	

	public void execute() throws ReverseException {
		
		tables = new ArrayList<String>();
		classes = new ArrayList<String>();
		
		
		File.checkMkdirs(arguments.getStoreRoot());	
		path = new File(arguments.getStoreRoot());
		
		
		manager = new DatabaseManager(arguments.getDbDriver(), arguments.getDbUrl(), arguments.getDbUser(), arguments.getDbPassword());
		for (TableBean bean : manager.getTables()) {
			String name = bean.name;
			
			
			if (arguments.getTableExcludeFilter()!=null) {
				if (name.toLowerCase().matches(arguments.getTableExcludeFilter())) {
					log.info("Jump table named '"+name+"', match exclude rule");
					continue;
				}
			}
			
			if (arguments.getTableIncludeFilter()!=null) {
				if (!name.toLowerCase().matches(arguments.getTableIncludeFilter())) {
					log.info("Jump table named '"+name+"', do not match include rule");
					continue;
				}
			}
			boolean view = "VIEW".equalsIgnoreCase(bean.type);
			
			TableInfo info = manager.getMetadata(name, view);
			String clazzName = createFile(name, info);
			
			tables.add(name);
			classes.add(clazzName);
		}
		
	}



	private String createFile(String tableName, TableInfo metadata) throws ReverseException {
		
		if (metadata!=null) {			
			ClazzTable clazz = new ClazzTable(arguments, tableName, metadata);			
			/*
				// TODO gestire i casi di omonimia e/o file gi presente con un warning
				log.warn("Class "+ clazz.getName()+" exists, overwrite!");
			*/
			
			clazz.write(arguments.getStoreRoot());
			
			return clazz.getName();
		}
		
		return null;
	}



	public List<String> getTables() {
		return tables;
	}



	public List<String> getClassNames() {
		return classes;
	}



	public java.io.File getPath() {
		return (java.io.File)path;
	}


	
	
	
	
	

}
