package it.softecspa.database.reverser;

import org.apache.tools.ant.Task;

public class ReverserAnt extends Task {

	final String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
	// "<!DOCTYPE log4j:configuration SYSTEM \"log4j.dtd\">" +
			"<log4j:configuration debug=\"false\" xmlns:log4j=\"http://jakarta.apache.org/log4j/\">" +
				"<!-- CONSOLE -->" + 
				"<appender name=\"console\" class=\"org.apache.log4j.ConsoleAppender\">" + 
					"<layout class=\"org.apache.log4j.PatternLayout\">" + 
						"<param name=\"ConversionPattern\" value=\"%m%n\" />" + 
					"</layout>" + 
				"</appender>" +
				"<!-- ROOT -->" + 
				"<root>" + 
					"<priority value=\"xxxlevelxxx\"/>" + 
					"<appender-ref ref=\"console\"/>" + 
				"</root>" + 
			"</log4j:configuration>";

	private String level;

	private Reverser reverser;
	private ArgumentsAnt arguments = new ArgumentsAnt();

	public void execute() {
		if (level == null || level.trim().equals(""))
			level = "ERROR";
		try {
			Log4Configurator.configure(xml.replaceAll("xxxlevelxxx", level));
		} catch (ReverseException e) {
			System.err.println(e.toString());
		}

		System.out.println("Analyze metadata...");
		reverser = new Reverser(arguments);
		try {
			reverser.execute();
		} catch (ReverseException e) {
			System.err.println(e.toString());
		}
		System.out.println("Processed " + reverser.getTables().size() + " tables");
		System.out.println("You can find classes in " + reverser.getPath().getAbsolutePath());
	}

	public void setPrefixLength(int value) {
		arguments.setTablePrefix(value);
	}

	public void setExclude(String value) {
		arguments.setTableExcludeFilter(value);
	}

	public void setInclude(String value) {
		arguments.setTableIncludeFilter(value);
	}

	public void setBlockAloneChar(boolean value) {
		arguments.setBlockAloneChar(value);
	}

	public void setRoot(String value) {
		arguments.setStoreRoot(value);
	}

	public void setPackage(String value) {
		arguments.setStorePackage(value);
	}

	public void setDriver(String value) {
		arguments.setDbDriver(value);
	}

	public void setUrl(String value) {
		arguments.setDbUrl(value);
	}

	public void setUser(String value) {
		arguments.setDbUser(value);
	}

	public void setPassword(String value) {
		arguments.setDbPassword(value);
	}

	public void setUpdateRecordTimestamp(boolean value) {
		arguments.setUpdateRecordTimestamp(value);
	}

	public void setDeleteWithCancel(boolean value) {
		arguments.setDeleteWithCancel(value);
	}

	public void setFlush(boolean value) {
		arguments.setFlush(value);
	}

	public void setClonable(boolean value) {
		arguments.setClonable(value);
	}

	public void setLevel(String level) {
		this.level = level;
	}

}
