package it.softecspa.database.reverser.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

public class TableInfo {

	Logger log = Logger.getLogger(getClass());
	
	private String name;
	private List<ColumnInfo> columns;
	private List<ColumnInfo> keys;
	
	private boolean view;

	
	public TableInfo(Connection connection, String name, boolean view) throws SQLException {
		this(connection.getMetaData(), name, view);
	}
	
	public TableInfo(DatabaseMetaData databaseMetaData, String name, boolean view) throws SQLException {
		this.name = name;
		this.view = view;
		
		columns = new ArrayList<ColumnInfo>();
		keys = new ArrayList<ColumnInfo>();
		
		
		ResultSet res = null;
		try {
			// COLUMNS
			res = databaseMetaData.getColumns(databaseMetaData.getConnection().getCatalog(), "%", name, null);
			while (res.next()) {
				ColumnInfo column = new ColumnInfo(res);
				columns.add(column);	
			}			
		
			// PRIMARY KEY
			res = databaseMetaData.getPrimaryKeys(databaseMetaData.getConnection().getCatalog(), "%", name);
			while (res.next()) {
				
				String column_name = res.getString("COLUMN_NAME");
				String pk_name = res.getString("PK_NAME");
				
				for (ColumnInfo column : columns) {
					if (column.getName().equals(column_name)) {
						keys.add(column);
						column.setPrimary(true);
						column.setPrimaryKeyName(pk_name);
						break;
					}
				}		
			}		
			
			/*
			res = databaseMetaData.getTypeInfo();
			res.next();
			*/
			
		} finally {	
			try {
				if (res!=null) res.close();
			} catch (SQLException e) {
				log.warn(e.toString(), e);
			}
		}	
	
		
	}


	public String getName() {
		return name;
	}


	public List<ColumnInfo> getColumns() {
		return columns;
	}


	public List<ColumnInfo> getKeys() {
		return keys;
	}


	public boolean isView() {
		return view;
	}
	
	
	
}
