package it.softecspa.kahuna.batch;

/**
 * Gestisce la lettura di un file e la sua elaborazione 
 */

import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.log.KLogger;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;



public class Elaborazioni {

	KLogger log = KLogger.getLogger(getClass());
	
	String pathLettura;
	String pathScrittura;
  
  List<File> listaElaborazioni = new ArrayList<File>(); // compliant java 5
  int prg=-1;
  boolean bCaricato = false;
  
  
  public Elaborazioni(String pathLettura, String pathScrittura) {
    this.pathLettura = pathLettura;
    this.pathScrittura = pathScrittura;    
  }
  
  public List<File> getList() {
    return getList(null,null);
  }
  
  public List<File> getList(it.softecspa.kahuna.io.FilenameFilter filtroN) {    
    return getList(filtroN,null);
  }

  public List<File> getList(java.io.FilenameFilter filtroJ) {    
    return getList(null,filtroJ);
  }
  
  private List<File> getList(it.softecspa.kahuna.io.FilenameFilter filtroN, java.io.FilenameFilter filtroJ) {
    if (!bCaricato) {
      if (filtroN!=null) {
        listaElaborazioni = File.dir(pathLettura,filtroN,true);
      } else if (filtroJ!=null) {
        listaElaborazioni = File.dir(pathLettura,filtroJ,true);
      } else {
        listaElaborazioni = File.dir(pathLettura,true);
      }      
      bCaricato = (listaElaborazioni!=null);
      if (listaElaborazioni.size()==0) {
    	  log.info("> Nessun file da elaborare");
      } else {
        log.info("> " + listaElaborazioni.size() + " file da elaborare");
      }
    }
    return listaElaborazioni;    
  }
  
  public File getFile() {
    if (listaElaborazioni.isEmpty()) return null;
    if (listaElaborazioni.size()<=prg) return null;
    if (prg<0) return null;
    return (File)listaElaborazioni.get(prg);
  }

  public boolean next() {
    prg++;
    if (listaElaborazioni.isEmpty()) return false;
    if (listaElaborazioni.size()<=prg) return false;
    log.info("Elaborazione del file " + this.getPathName() + " - n."+(this.getIndex()+1));
    return true;
  }

  public String getName() {
    if (listaElaborazioni.isEmpty()) return null;
    if (listaElaborazioni.size()<=prg) return null;
    if (prg<0) return null;
    File appo = (File)listaElaborazioni.get(prg);
    return appo.getName();
  }

  public String getPathName() {
    return pathLettura + getName();
  }

  public boolean renameTo() {
    if (listaElaborazioni.isEmpty()) return false;
    if (listaElaborazioni.size()<=prg) return false;
    if (prg<0) return false;

    File oldFile = (File)listaElaborazioni.get(prg);

    try {
      File newFile = new File(pathScrittura + oldFile.getName());
      boolean bOk = oldFile.renameTo(newFile);
      listaElaborazioni.remove(prg);
      listaElaborazioni.add(prg,newFile);
      if (bOk) {
        log.debug("File spostato in " + newFile.getPath());
      } else {
        log.error("Errore in spostamento file " + oldFile.getName(), null);
      }
      return bOk;
      
    } catch (Exception e) {
    	log.error("Errore in spostamento file " + oldFile.getName(), e);
      return false;
    }
  }

  public int getIndex() {
    return prg;
  }

  
  public boolean renameToProtected() {
    return renameToProtected(new SimpleDateFormat(".yyyyMMddHHmmss"));
  }
  
  public boolean renameToProtected(SimpleDateFormat df) {
    if (listaElaborazioni.isEmpty()) return false;
    if (listaElaborazioni.size()<=prg) return false;
    if (prg<0) return false;

    File oldFile = (File)listaElaborazioni.get(prg);

    try {
      if (df==null) df = new SimpleDateFormat(".yyyyMMddHHmmss");
      String protezione= df.format(Calendar.getInstance(Locale.ITALY).getTime());    
      
      File newFile = new File(pathScrittura + oldFile.getName() + protezione);
      oldFile.renameTo(newFile);
      listaElaborazioni.remove(prg);
      listaElaborazioni.add(prg,newFile);
      log.debug("File rinominato/spostato in " + newFile.getPath());
      return true;
      
    } catch (Exception e) {
    	log.error("Errore in spostamento file " + oldFile.getName(),e);
      return false;
    }
    
  }

}