package it.softecspa.kahuna.batch.file;

import java.util.Enumeration;
import java.util.Hashtable;


public class ParserMap { 
  
  private class Element {
    private Integer inizio = null;
    private Integer fine = null;
    
    private Integer getFine() {
      return fine;
    }
    
    private void setFine(Integer fine) {
      this.fine = fine;
    }
    
    private Integer getInizio() {
      return inizio;
    }
    
    private void setInizio(Integer inizio) {
      this.inizio = inizio;
    }
    
  }
  
  public static final int BASE0 = 0;
  public static final int BASE1 = 1; 
  
  private Hashtable<String, Element> mappa; 
  private int base = BASE0;
  
  private Integer length;
  
  
  public ParserMap() {
    this(10);
  }
  
  
  public ParserMap(int elementi) {
    this(elementi,ParserMap.BASE0);
  }

  public ParserMap(int elementi, int base) {
    mappa = new Hashtable<String, Element>(elementi);
    this.base = base;
  }
  
  /**
   * @deprecated 
   */
  public void add(String nome, int inizio) {
    Element pme = new Element();
    pme.setInizio(new Integer(inizio));
    pme.setFine(null);     
    
    mappa.put(nome,pme);
  }
  
  public void add(String nome, int inizio, int fine) {
    Element pme = new Element();
    pme.setInizio(new Integer(inizio));
    pme.setFine(new Integer(fine));   
    
    mappa.put(nome,pme);
    
    if (length==null || length.intValue()<fine) {
      length = new Integer(fine);
    }
    
  }
  
  
  public Integer getInizio(String nome) {
    Element pme = (Element)mappa.get(nome);
    if (pme==null) return null;
    return pme.getInizio();
  }
  
  public Integer getFine(String nome) {
    Element pme = (Element)mappa.get(nome);
    if (pme==null) return null;
    return pme.getFine();    
  }
  
  
  public int getBase() {
    return this.base;
  }
  
  public Enumeration<String> keys() {
    return mappa.keys();
  }


  /**
   * Imposta la lunghezza del record in modo da eseguire una comparazione preliminare
   */
  public void setLength(int i) {
    if (i>0) length = new Integer(i);
  }
  
  
  public void setLength(Integer i) {    
    if (i!=null && i.intValue() >0) length = i;
  }  
  
  
  public int getLength() {
    return (length!=null?length.intValue():-1);
  }
  
  
  
}
