package it.softecspa.kahuna.batch.file;

import it.softecspa.kahuna.lang.XString;

import java.io.IOException;



public class ParserRiga {
  
  Riga riga = null;
  ParserMap parserMap = null;;
  
  public ParserRiga(Riga riga, ParserMap parserMap) {
    this.riga = new Riga(riga);
    this.parserMap = parserMap;
  }
  
  public boolean next() throws IOException {
    return riga.next();
  }
  
  public Riga getRiga() {
    return riga;
  }
  
  public ParserMap getParserMap() {
    return parserMap;
  }
  
  public String valueOf(String chiave) throws ParserException {
    Integer inizio = parserMap.getInizio(chiave);
    Integer fine = parserMap.getFine(chiave);
    
    
    if (inizio==null) throw new ParserException("Inizio nullo",chiave);
    /*
     * TODO: inserire eccezione
     */
    
    if (inizio==fine) throw new ParserException("Inizio uguale a fine: "+inizio+"="+fine, chiave);    
    if (inizio.intValue()<parserMap.getBase()) throw new ParserException("Inizio non valido: "+inizio+">"+parserMap.getBase(), chiave); 
    
    int n1 = inizio.intValue() - parserMap.getBase();
    if (inizio.intValue()>riga.getRecord().length()) throw new ParserException("Inizio oltre lunghezza record: "+inizio+"<"+riga.getRecord().length(), chiave);
    
    if (fine!=null) {
      if (inizio.compareTo(fine)>0) throw new ParserException("Inizio e fine invertiti: "+inizio+"<"+fine, chiave);        
      if (fine.intValue()>riga.getRecord().length()) throw new ParserException("Fine oltre lunghezza record: "+fine+"<"+riga.getRecord().length(), chiave);
      if (fine.intValue()<parserMap.getBase()) throw new ParserException("Fine non valida: "+fine+">"+parserMap.getBase(), chiave);
    
      int n2 = fine.intValue() - parserMap.getBase();      
      return riga.getRecord().substring(n1,n2); 
      
    } else {      
      return riga.getRecord().substring(n1);
    }    
  }
  
  
  public String valueOfTrim(String chiave) throws ParserException {
    if (valueOf(chiave)!=null) {
      String s = valueOf(chiave).trim();
      return (s.equals("")?null:s); 
    }
    return null;
  }
  
  
  public boolean replace(String chiave, String valore) throws ParserException {
    if (valore==null) return false;
    
    /*
     * TODO: inserire eccezione
     */
    String result = this.valueOf(chiave);
    if (result==null) return false;
    
    if (valore.length()>result.length()) return false;
    
    if (!valore.equals(result)) {
      if (valore.length()<result.length()) valore=XString.fillerSpaceRight(valore,result.length()-valore.length());
      
      Integer inizio = parserMap.getInizio(chiave);
      Integer fine = parserMap.getFine(chiave);
      if (fine!=null) {
        riga.setRecord(riga.getRecord().substring(0,inizio.intValue()) +
                       valore +
                       riga.getRecord().substring(fine.intValue()));
      } else {
        riga.setRecord(riga.getRecord().substring(0,inizio.intValue()) +
                       valore);
        
      }
    }
    
    return true;
  }
  
  
  /**
   * Restituisce true se la stringa  di lunghezza sufficiente ad essere parsata
   * prendendo il valore da quello impostato nella mappa
   * @return
   */
  public boolean isLengthEnough() {
    return (riga.length()>=parserMap.getLength());     
  }
  
  
}
