package it.softecspa.kahuna.batch.file;

import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;



public class ParserRigaPlus extends ParserRiga {

  /*
   * TODO Inserire tutti i metodi utili
   * TODO Gestione dei null
   * TODO Gestione dell'errore con eccezione
   */
  
  public ParserRigaPlus(Riga riga, ParserMap parserMap) {
    super(riga, parserMap);    
  }

  /**
   * Restituisce un valore di tipo long
   * @param chiave
   * @return
   * @throws ParserException
   */
  public long longValueOf(String chiave) throws ParserException {
    String s = super.valueOfTrim(chiave);
    return Long.parseLong(s);
  }
  
  /**
   * restituisce un valore di tipo int
   * @param chiave
   * @return
   * @throws ParserException
   */
  public int intValueOf(String chiave) throws ParserException {
    String s = super.valueOfTrim(chiave);
    return Integer.parseInt(s);
  }
  
  
  public EnterpriseCalendar calendarioValueOf(String chiave, String formato) throws ParserException {
    
    String valore = super.valueOfTrim(chiave);
    if (valore==null) return null;
    if (formato==null) throw new ParserException("Formato nullo", chiave);
    if (valore.length()!=formato.length()) throw new ParserException("Lunghezza formato diversa da valore: "+formato.length()+"!="+valore.length(), chiave);
    
    SimpleDateFormat sdf = new SimpleDateFormat(formato);
    Date d = null;
	try {
		d = sdf.parse(valore);
	} catch (ParseException e) {
		new ParserException("Errore di parsing della data", chiave,e);
	}
    return EnterpriseCalendar.newInstance(d);

    
    /*
     
    int anno=0;
    int mese=0;
    int giorno=0;
    int ore=0;
    int minuti=0;
    int secondi=0;
      
     
    //...
    formato=formato+"\t"; //Aggiungo un carattere per motivi pratici
    char[] sFormatoArray=formato.toUpperCase().toCharArray();
    int MAX=formato.length() - 1;
  
    String sBlocchetto="";
    for (int i=0, f=0; f<MAX; f++) {
      sBlocchetto = sBlocchetto + sFormatoArray[f];
      if (sFormatoArray[f] != sFormatoArray[f + 1])  {
        //Valuto sBlocchetto per vedere se  un parametro conosciuto
        if (sBlocchetto.equals("YY")) {
          anno=Integer.parseInt(valore.substring(i,f+1));
          
        } else if (sBlocchetto.equals("YYYY")) {
          anno=Integer.parseInt(valore.substring(i,f+1));
          
        } else if (sBlocchetto.equals("MM")) {
          mese=Integer.parseInt(valore.substring(i,f+1));
          
        } else if (sBlocchetto.equals("DD")) {
          giorno=Integer.parseInt(valore.substring(i,f+1));
          
        } else if (sBlocchetto.equals("HH") || sBlocchetto.equals("HH24")) {
          ore=Integer.parseInt(valore.substring(i,f+1));
          
        } else if (sBlocchetto.equals("NN") || sBlocchetto.equals("MI")) {
          minuti=Integer.parseInt(valore.substring(i,f+1));
          
        } else if (sBlocchetto.equalsIgnoreCase("SS")) {
          secondi=Integer.parseInt(valore.substring(i,f+1));          
        }
        sBlocchetto="";
        i=f+1;
      }
    }
    if (anno==0 && mese==0 && giorno==0 && ore==0 && minuti==0 && secondi==0) return null;
    return new EnterpriseCalendar(anno,mese,giorno,ore,minuti,secondi);
    */
  }

  public double doubleValueOf(String chiave, int i, int d) throws ParserException {
    String s = this.valueOf(chiave);
    String si = s.substring(0,i);
    String sd = s.substring(i,i+d);
    return Double.parseDouble(si+"."+sd);
  }
  
  
  
  
}
