package it.softecspa.kahuna.batch.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;



public class Riga {
  private BufferedReader br=null;
  // Buffer di record letto
  private String bufferRecord=null;
  // Progressivo di record
  long progressivo=0;
  // File in elaborazione
  File file=null;
  
 
  public Riga() {    
  }
 
  public Riga(Riga riga) {
    bufferRecord = riga.getRecord();
    progressivo = riga.index();  
  }
  
  /**
   * Apre il file il lettura
   * @param elabFile Nome del file da aprire
   * @throws java.io.FileNotFoundException
   * @throws java.io.IOException
   */
  public void open(File file) throws java.io.FileNotFoundException, java.io.IOException {
    this.file = file;
    
    FileInputStream inputStream = new FileInputStream(file);
    br = new BufferedReader(new InputStreamReader(inputStream));
    progressivo=0;
  }

  
  /**
   * Scorre il file, posizionando il cursore sul record successivo
   * @return false quando il file  terminato
   * @throws java.io.IOException
   */
  public boolean next() throws java.io.IOException {
     boolean trovata = ((bufferRecord = br.readLine()) != null);
     // Quando riga==null allora ho raggiunto la fine del file
     progressivo++;
     return trovata;
  }

  
  /**
   * Chiude il file aperto in lettura   *
   */
  public void close() {
    try {
      if (br!=null) br.close();
    } catch (Exception e) {
      //Debug.livelloError("Errore in chiusura file ",e);
    }
  }

  /**
   * Restituisce la lunghezza del record letto
   * @return
   */
  public int length() {
    return bufferRecord.length();
  }

  /**
   * Restituisce l'indice di record letto
   * @return
   */
  public long index() {
    return progressivo;
  }
  
  /** 
   * @deprecated
   */
  public long posizione() {
    return (progressivo+1);
  }  
  
  /**
   * Restituisce l'ultimo record letto
   * @return
   */
  public String getRecord() {
    return bufferRecord;
  }
  
  /**
   * @param string
   */
  public void setRecord(String valore) {
    bufferRecord = valore;    
  }
  
  /**
   * Restituisce uan sottostringa dell'ultimo record letto
   * @param fine
   * @return
   */
  public String substring(int fine) {
    return bufferRecord.substring(fine);
  }
  
  /**
   * Restituisce uan sottostringa dell'ultimo record letto
   * @param inizio
   * @param fine
   * @return
   */
  public String substring(int inizio, int fine) {
    return bufferRecord.substring(inizio,fine);
  }
  
	/**
	 * @return
	 */
	public File getFile() {
		return file;
	}



}
